DROP TABLE IF EXISTS `zones`;
CREATE TABLE `zones` (
	`zone_id` int(11) NOT NULL AUTO_INCREMENT,
	`zone_country_id` int(11) NOT NULL DEFAULT '0',
	`zone_code` varchar(32) NOT NULL DEFAULT '',
	`zone_name` varchar(128) NOT NULL DEFAULT '',
	PRIMARY KEY (`zone_id`),
	UNIQUE KEY `unique_country_zone` (`zone_country_id`,`zone_code`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

INSERT INTO `zones` (`zone_id`, `zone_country_id`, `zone_code`, `zone_name`) VALUES
	(1, 1, "BAL", "Balkh"),
	(2, 1, "BAM", "Bāmyān"),
	(3, 1, "BDG", "Bādghīs"),
	(4, 1, "BDS", "Badakhshān"),
	(5, 1, "BGL", "Baghlān"),
	(6, 1, "DAY", "Dāykundī"),
	(7, 1, "FRA", "Farāh"),
	(8, 1, "FYB", "Fāryāb"),
	(9, 1, "GHA", "Ghaznī"),
	(10, 1, "GHO", "Ghōr"),
	(11, 1, "HEL", "Helmand"),
	(12, 1, "HER", "Herāt"),
	(13, 1, "JOW", "Jowzjān"),
	(14, 1, "KAB", "Kābul"),
	(15, 1, "KAN", "Kandahār"),
	(16, 1, "KAP", "Kāpīsā"),
	(17, 1, "KDZ", "Kunduz"),
	(18, 1, "KHO", "Khōst"),
	(19, 1, "KNR", "Kunar"),
	(20, 1, "LAG", "Laghmān"),
	(21, 1, "LOG", "Lōgar"),
	(22, 1, "NAN", "Nangarhār"),
	(23, 1, "NIM", "Nīmrōz"),
	(24, 1, "NUR", "Nūristān"),
	(25, 1, "PAN", "Panjshayr"),
	(26, 1, "PAR", "Parwān"),
	(27, 1, "PIA", "Paktia"),
	(28, 1, "PKA", "Paktika"),
	(29, 1, "SAM", "Samangan"),
	(30, 1, "SAR", "Sar-e Pul"),
	(31, 1, "TAK", "Takhar"),
	(32, 1, "URU", "Uruzgān"),
	(33, 1, "WAR", "Wardak"),
	(34, 1, "ZAB", "Zābul"),
	(47, 2, "BR", "Berat"),
	(48, 2, "BU", "Bulqizë"),
	(49, 2, "DI", "Dibër"),
	(50, 2, "DL", "Delvinë"),
	(51, 2, "DR", "Durrës"),
	(52, 2, "DV", "Devoll"),
	(53, 2, "EL", "Elbasan"),
	(54, 2, "ER", "Kolonjë"),
	(55, 2, "FR", "Fier"),
	(56, 2, "GJ", "Gjirokastër"),
	(57, 2, "GR", "Gramsh"),
	(58, 2, "HA", "Has"),
	(59, 2, "KA", "Kavajë"),
	(60, 2, "KB", "Kurbin"),
	(61, 2, "KC", "Kuçovë"),
	(62, 2, "KO", "Korçë"),
	(63, 2, "KR", "Krujë"),
	(64, 2, "KU", "Kukës"),
	(65, 2, "LB", "Librazhd"),
	(66, 2, "LE", "Lezhë"),
	(67, 2, "LU", "Lushnjë"),
	(68, 2, "MK", "Mallakastër"),
	(69, 2, "MM", "Malësi e Madhe"),
	(70, 2, "MR", "Mirditë"),
	(71, 2, "MT", "Mat"),
	(72, 2, "PG", "Pogradec"),
	(73, 2, "PQ", "Peqin"),
	(74, 2, "PR", "Përmet"),
	(75, 2, "PU", "Pukë"),
	(76, 2, "SH", "Shkodër"),
	(77, 2, "SK", "Skrapar"),
	(78, 2, "SR", "Sarandë"),
	(79, 2, "TE", "Tepelenë"),
	(80, 2, "TP", "Tropojë"),
	(81, 2, "TR", "Tiranë"),
	(82, 2, "VL", "Vlorë"),
	(83, 3, "01", "Adrar"),
	(84, 3, "02", "Chlef"),
	(85, 3, "03", "Laghouat"),
	(86, 3, "04", "Oum el Bouaghi"),
	(87, 3, "05", "Batna"),
	(88, 3, "06", "Béjaïa"),
	(89, 3, "07", "Biskra"),
	(90, 3, "08", "Béchar"),
	(91, 3, "09", "Blida"),
	(92, 3, "10", "Bouira"),
	(93, 3, "11", "Tamanghasset"),
	(94, 3, "12", "Tébessa"),
	(95, 3, "13", "Tlemcen"),
	(96, 3, "14", "Tiaret"),
	(97, 3, "15", "Tizi Ouzou"),
	(98, 3, "16", "Alger"),
	(99, 3, "17", "Djelfa"),
	(100, 3, "18", "Jijel"),
	(101, 3, "19", "Sétif"),
	(102, 3, "20", "Saïda"),
	(103, 3, "21", "Skikda"),
	(104, 3, "22", "Sidi Bel Abbès"),
	(105, 3, "23", "Annaba"),
	(106, 3, "24", "Guelma"),
	(107, 3, "25", "Constantine"),
	(108, 3, "26", "Médéa"),
	(109, 3, "27", "Mostaganem"),
	(110, 3, "28", "Msila"),
	(111, 3, "29", "Mascara"),
	(112, 3, "30", "Ouargla"),
	(113, 3, "31", "Oran"),
	(114, 3, "32", "El Bayadh"),
	(115, 3, "33", "Illizi"),
	(116, 3, "34", "Bordj Bou Arréridj"),
	(117, 3, "35", "Boumerdès"),
	(118, 3, "36", "El Tarf"),
	(119, 3, "37", "Tindouf"),
	(120, 3, "38", "Tissemsilt"),
	(121, 3, "39", "El Oued"),
	(122, 3, "40", "Khenchela"),
	(123, 3, "41", "Souk Ahras"),
	(124, 3, "42", "Tipaza"),
	(125, 3, "43", "Mila"),
	(126, 3, "44", "Aïn Defla"),
	(127, 3, "45", "Naama"),
	(128, 3, "46", "Aïn Témouchent"),
	(129, 3, "47", "Ghardaïa"),
	(130, 3, "48", "Relizane"),
	(131, 5, "02", "Canillo"),
	(132, 5, "03", "Encamp"),
	(133, 5, "04", "La Massana"),
	(134, 5, "05", "Ordino"),
	(135, 5, "06", "Sant Julià de Lòria"),
	(136, 5, "07", "Andorra la Vella"),
	(137, 5, "08", "Escaldes-Engordany"),
	(138, 6, "BGO", "Bengo"),
	(139, 6, "BGU", "Benguela"),
	(140, 6, "BIE", "Bié"),
	(141, 6, "CAB", "Cabinda"),
	(142, 6, "CCU", "Cuando-Cubango"),
	(143, 6, "CNN", "Cunene"),
	(144, 6, "CNO", "Cuanza Norte"),
	(145, 6, "CUS", "Cuanza Sul"),
	(146, 6, "HUA", "Huambo"),
	(147, 6, "HUI", "Huíla"),
	(148, 6, "LNO", "Lunda Norte"),
	(149, 6, "LSU", "Lunda Sul"),
	(150, 6, "LUA", "Luanda"),
	(151, 6, "MAL", "Malange"),
	(152, 6, "MOX", "Moxico"),
	(153, 6, "NAM", "Namibe"),
	(154, 6, "UIG", "Uíge"),
	(155, 6, "ZAI", "Zaire"),
	(156, 9, "03", "Saint George"),
	(157, 9, "04", "Saint John’s"),
	(158, 9, "05", "Saint Mary"),
	(159, 9, "06", "Saint Paul"),
	(160, 9, "07", "Saint Peter"),
	(161, 9, "08", "Saint Philip"),
	(162, 9, "10", "Barbuda"),
	(163, 9, "11", "Redonda"),
	(164, 10, "BA", "Buenos Aires"),
	(165, 10, "CC", "Chaco"),
	(166, 10, "CD", "Córdoba"),
	(167, 10, "CF", "Buenos Aires City"),
	(168, 10, "CH", "Chubut"),
	(169, 10, "CR", "Corrientes"),
	(170, 10, "CT", "Catamarca"),
	(171, 10, "ER", "Entre Ríos"),
	(172, 10, "FO", "Formosa"),
	(173, 10, "JY", "Jujuy"),
	(174, 10, "LP", "La Pampa"),
	(175, 10, "LR", "La Rioja"),
	(176, 10, "MN", "Misiones"),
	(177, 10, "MZ", "Mendoza"),
	(178, 10, "NQ", "Neuquén"),
	(179, 10, "RN", "Río Negro"),
	(180, 10, "SA", "Salta"),
	(181, 10, "SC", "Santa Cruz"),
	(182, 10, "SE", "Santiago del Estero"),
	(183, 10, "SF", "Santa Fe"),
	(184, 10, "SJ", "San Juan"),
	(185, 10, "SL", "San Luis"),
	(186, 10, "TF", "Tierra del Fuego"),
	(187, 10, "TM", "Tucumán"),
	(188, 11, "AG", "Aragatsotn"),
	(189, 11, "AR", "Ararat"),
	(190, 11, "AV", "Armavir"),
	(191, 11, "ER", "Yerevan"),
	(192, 11, "GR", "Gegharkunik"),
	(193, 11, "KT", "Kotayk"),
	(194, 11, "LO", "Lori"),
	(195, 11, "SH", "Shirak"),
	(196, 11, "SU", "Syunik"),
	(197, 11, "TV", "Tavush"),
	(198, 11, "VD", "Vayoc Jor"),
	(199, 13, "ACT", "Australian Capital Territory"),
	(200, 13, "NSW", "New South Wales"),
	(201, 13, "NT", "Northern Territory"),
	(202, 13, "QLD", "Queensland"),
	(203, 13, "SA", "South Australia"),
	(204, 13, "TAS", "Tasmania"),
	(205, 13, "VIC", "Victoria"),
	(206, 13, "WA", "Western Australia"),
	(207, 14, "BL", "Burgenland"),
	(208, 14, "KN", "Kärnten"),
	(209, 14, "NO", "Niederösterreich"),
	(210, 14, "OO", "Oberösterreich"),
	(211, 14, "SB", "Salzburg"),
	(212, 14, "ST", "Steiermark"),
	(213, 14, "TI", "Tirol"),
	(214, 14, "VB", "Vorarlberg"),
	(215, 14, "WI", "Wien"),
	(216, 15, "ABS", "Abseron"),
	(217, 15, "AGA", "Agstafa"),
	(218, 15, "AGC", "Agcabädi"),
	(219, 15, "AGM", "Agdam"),
	(220, 15, "AGS", "Agdas"),
	(221, 15, "AGU", "Agsu"),
	(222, 15, "AST", "Astara"),
	(223, 15, "BA", "Baki"),
	(224, 15, "BAB", "Babäk"),
	(225, 15, "BAL", "Balakän"),
	(226, 15, "BAR", "Bärdä"),
	(227, 15, "BEY", "Beyläqan"),
	(228, 15, "BIL", "Biläsuvar"),
	(229, 15, "CAB", "Cäbrayil"),
	(230, 15, "CAL", "Cälilabab"),
	(231, 15, "CUL", "Culfa"),
	(232, 15, "DAS", "Daskäsän"),
	(233, 15, "FUZ", "Füzuli"),
	(234, 15, "GA", "Gəncə"),
	(235, 15, "GAD", "Gädäbäy"),
	(236, 15, "GOR", "Goranboy"),
	(237, 15, "GOY", "Göyçay"),
	(238, 15, "GYG", "Göygöl"),
	(239, 15, "HAC", "Haciqabul"),
	(240, 15, "IMI", "Imisli"),
	(241, 15, "ISM", "Ismayilli"),
	(242, 15, "KAL", "Kälbäcär"),
	(243, 15, "KAN", "Kǝngǝrli"),
	(244, 15, "KUR", "Kürdämir"),
	(245, 15, "LA", "Lənkəran"),
	(246, 15, "LAC", "Laçin"),
	(247, 15, "LAN", "Länkäran"),
	(248, 15, "LER", "Lerik"),
	(249, 15, "MAS", "Masalli"),
	(250, 15, "MI", "Mingəçevir"),
	(251, 15, "NA", "Naftalan"),
	(252, 15, "NEF", "Neftçala"),
	(253, 15, "NV", "Naxçıvan"),
	(254, 15, "NX", "Naxçivan"),
	(255, 15, "OGU", "Oguz"),
	(256, 15, "ORD", "Ordubad"),
	(257, 15, "QAB", "Qäbälä"),
	(258, 15, "QAX", "Qax"),
	(259, 15, "QAZ", "Qazax"),
	(260, 15, "QBA", "Quba"),
	(261, 15, "QBI", "Qubadli"),
	(262, 15, "QOB", "Qobustan"),
	(263, 15, "QUS", "Qusar"),
	(264, 15, "SA", "Şəki"),
	(265, 15, "SAB", "Sabirabad"),
	(266, 15, "SAD", "Sädäräk"),
	(267, 15, "SAH", "Sahbuz"),
	(268, 15, "SAK", "Säki"),
	(269, 15, "SAL", "Salyan"),
	(270, 15, "SAR", "Särur"),
	(271, 15, "SAT", "Saatli"),
	(272, 15, "SBN", "Şabran"),
	(273, 15, "SIY", "Siyäzän"),
	(274, 15, "SKR", "Sämkir"),
	(275, 15, "SM", "Sumqayıt"),
	(276, 15, "SMI", "Samaxi"),
	(277, 15, "SMX", "Samux"),
	(278, 15, "SR", "Şirvan"),
	(279, 15, "SUS", "Susa"),
	(280, 15, "TAR", "Tärtär"),
	(281, 15, "TOV", "Tovuz"),
	(282, 15, "UCA", "Ucar"),
	(283, 15, "XA", "Xankəndi"),
	(284, 15, "XAC", "Xaçmaz"),
	(285, 15, "XCI", "Xocali"),
	(286, 15, "XIZ", "Xizi"),
	(287, 15, "XVD", "Xocavänd"),
	(288, 15, "YAR", "Yardimli"),
	(289, 15, "YE", "Yevlax City"),
	(290, 15, "YEV", "Yevlax"),
	(291, 15, "ZAN", "Zängilan"),
	(292, 15, "ZAQ", "Zaqatala"),
	(293, 15, "ZAR", "Zärdab"),
	(294, 16, "AK", "Acklins Islands"),
	(295, 16, "BI", "Bimini and Cat Cay"),
	(296, 16, "BP", "Black Point"),
	(297, 16, "BY", "Berry Islands"),
	(298, 16, "CE", "Central Eleuthera"),
	(299, 16, "CI", "Cat Island"),
	(300, 16, "CK", "Crooked Island and Long Cay"),
	(301, 16, "CO", "Central Abaco"),
	(302, 16, "CS", "Central Andros"),
	(303, 16, "EG", "East Grand Bahama"),
	(304, 16, "EX", "Exuma"),
	(305, 16, "FP", "City of Freeport"),
	(306, 16, "GC", "Grand Cay"),
	(307, 16, "GT", "Green Turtle Cay"),
	(308, 16, "HI", "Harbour Island"),
	(309, 16, "HT", "Hope Town"),
	(310, 16, "IN", "Inagua"),
	(311, 16, "LI", "Long Island"),
	(312, 16, "MC", "Mangrove Cay"),
	(313, 16, "MG", "Mayaguana"),
	(314, 16, "MI", "Moore’s Island"),
	(315, 16, "NE", "North Eleuthera"),
	(316, 16, "NO", "North Abaco"),
	(317, 16, "NS", "North Andros"),
	(318, 16, "RC", "Rum Cay"),
	(319, 16, "RI", "Ragged Island"),
	(320, 16, "SA", "South Andros"),
	(321, 16, "SE", "South Eleuthera"),
	(322, 16, "SO", "South Abaco"),
	(323, 16, "SS", "San Salvador"),
	(324, 16, "SW", "Spanish Wells"),
	(325, 16, "WG", "West Grand Bahama"),
	(326, 17, "13", "Al Manamah (Al ‘Asimah)"),
	(327, 17, "14", "Al Janubiyah"),
	(328, 17, "15", "Al Muharraq"),
	(329, 17, "16", "Al Wustá"),
	(330, 17, "17", "Ash Shamaliyah"),
	(331, 18, "01", "Bandarban"),
	(332, 18, "02", "Barguna"),
	(333, 18, "03", "Bogra"),
	(334, 18, "04", "Brahmanbaria"),
	(335, 18, "05", "Bagerhat"),
	(336, 18, "06", "Barisal"),
	(337, 18, "07", "Bhola"),
	(338, 18, "08", "Comilla"),
	(339, 18, "09", "Chandpur"),
	(340, 18, "10", "Chittagong"),
	(341, 18, "11", "Cox's Bazar"),
	(342, 18, "12", "Chuadanga"),
	(343, 18, "13", "Dhaka"),
	(344, 18, "14", "Dinajpur"),
	(345, 18, "15", "Faridpur"),
	(346, 18, "16", "Feni"),
	(347, 18, "17", "Gopalganj"),
	(348, 18, "18", "Gazipur"),
	(349, 18, "19", "Gaibandha"),
	(350, 18, "20", "Habiganj"),
	(351, 18, "21", "Jamalpur"),
	(352, 18, "22", "Jessore"),
	(353, 18, "23", "Jhenaidah"),
	(354, 18, "24", "Jaipurhat"),
	(355, 18, "25", "Jhalakati"),
	(356, 18, "26", "Kishoreganj"),
	(357, 18, "27", "Khulna"),
	(358, 18, "28", "Kurigram"),
	(359, 18, "29", "Khagrachari"),
	(360, 18, "30", "Kushtia"),
	(361, 18, "31", "Lakshmipur"),
	(362, 18, "32", "Lalmonirhat"),
	(363, 18, "33", "Manikganj"),
	(364, 18, "34", "Mymensingh"),
	(365, 18, "35", "Munshiganj"),
	(366, 18, "36", "Madaripur"),
	(367, 18, "37", "Magura"),
	(368, 18, "38", "Moulvibazar"),
	(369, 18, "39", "Meherpur"),
	(370, 18, "40", "Narayanganj"),
	(371, 18, "41", "Netrakona"),
	(372, 18, "42", "Narsingdi"),
	(373, 18, "43", "Narail"),
	(374, 18, "44", "Natore"),
	(375, 18, "45", "Nawabganj"),
	(376, 18, "46", "Nilphamari"),
	(377, 18, "47", "Noakhali"),
	(378, 18, "48", "Naogaon"),
	(379, 18, "49", "Pabna"),
	(380, 18, "50", "Pirojpur"),
	(381, 18, "51", "Patuakhali"),
	(382, 18, "52", "Panchagarh"),
	(383, 18, "53", "Rajbari"),
	(384, 18, "54", "Rajshahi"),
	(385, 18, "55", "Rangpur"),
	(386, 18, "56", "Rangamati Parbattya Chattagram"),
	(387, 18, "57", "Sherpur"),
	(388, 18, "58", "Satkhira"),
	(389, 18, "59", "Sirajganj"),
	(390, 18, "60", "Sylhet"),
	(391, 18, "61", "Sunamganj"),
	(392, 18, "62", "Shariatpur"),
	(393, 18, "63", "Tangail"),
	(394, 18, "64", "Thakurgaon"),
	(402, 19, "01", "Christ Church"),
	(403, 19, "02", "Saint Andrew"),
	(404, 19, "03", "Saint George"),
	(405, 19, "04", "Saint James"),
	(406, 19, "05", "Saint John"),
	(407, 19, "06", "Saint Joseph"),
	(408, 19, "07", "Saint Lucy"),
	(409, 19, "08", "Saint Michael"),
	(410, 19, "09", "Saint Peter"),
	(411, 19, "10", "Saint Philip"),
	(412, 19, "11", "Saint Thomas"),
	(413, 20, "BR", "Brestskaya voblasts"),
	(414, 20, "HM", "Horad Minsk"),
	(415, 20, "HO", "Homyel'skaya voblasts"),
	(416, 20, "HR", "Hrodzenskaya voblasts"),
	(417, 20, "MA", "Mahilyowskaya voblasts"),
	(418, 20, "MI", "Minskaya voblasts"),
	(419, 20, "VI", "Vitsyebskaya voblasts"),
	(420, 21, "BRU", "Brussels"),
	(421, 21, "VAN", "Antwerpen"),
	(422, 21, "VBR", "Vlaams Brabant"),
	(423, 21, "VLG", "Flemish Region"),
	(424, 21, "VLI", "Limburg"),
	(425, 21, "VOV", "Oost-Vlaanderen"),
	(426, 21, "VWV", "West-Vlaanderen"),
	(427, 21, "WAL", "Wallonia"),
	(428, 21, "WBR", "Brabant Wallon"),
	(429, 21, "WHT", "Hainaut"),
	(430, 21, "WLG", "Liège"),
	(431, 21, "WLX", "Luxembourg"),
	(432, 21, "WNA", "Namur"),
	(433, 22, "BZ", "Belize"),
	(434, 22, "CY", "Cayo"),
	(435, 22, "CZL", "Corozal"),
	(436, 22, "OW", "Orange Walk"),
	(437, 22, "SC", "Stann Creek"),
	(438, 22, "TOL", "Toledo"),
	(439, 23, "AK", "Atakora"),
	(440, 23, "AL", "Alibori"),
	(441, 23, "AQ", "Atlantique"),
	(442, 23, "BO", "Borgou"),
	(443, 23, "CO", "Collines"),
	(444, 23, "DO", "Donga"),
	(445, 23, "KO", "Kouffo"),
	(446, 23, "LI", "Littoral"),
	(447, 23, "MO", "Mono"),
	(448, 23, "OU", "Ouémé"),
	(449, 23, "PL", "Plateau"),
	(450, 23, "ZO", "Zou"),
	(451, 24, "DEV", "Devonshire"),
	(452, 24, "HA", "Hamilton municipality"),
	(453, 24, "HAM", "Hamilton"),
	(454, 24, "PAG", "Paget"),
	(455, 24, "PEM", "Pembroke"),
	(456, 24, "SAN", "Sandys"),
	(457, 24, "SG", "Saint George municipality"),
	(458, 24, "SGE", "Saint George"),
	(459, 24, "SMI", "Smiths"),
	(460, 24, "SOU", "Southampton"),
	(461, 24, "WAR", "Warwick"),
	(462, 25, "11", "Paro"),
	(463, 25, "12", "Chhukha"),
	(464, 25, "13", "Ha"),
	(465, 25, "14", "Samtse"),
	(466, 25, "15", "Thimphu"),
	(467, 25, "21", "Tsirang"),
	(468, 25, "22", "Dagana"),
	(469, 25, "23", "Punakha"),
	(470, 25, "24", "Wangdue Phodrang"),
	(471, 25, "31", "Sarpang"),
	(472, 25, "32", "Trongsa"),
	(473, 25, "33", "Bumthang"),
	(474, 25, "34", "Zhemgang"),
	(475, 25, "41", "Trashigang"),
	(476, 25, "42", "Monggar"),
	(477, 25, "43", "Pemagatshel"),
	(478, 25, "44", "Lhuentse"),
	(479, 25, "45", "Samdrup Jongkha"),
	(480, 25, "GA", "Gasa"),
	(481, 25, "TY", "Trashi Yangtse"),
	(482, 26, "B", "El Beni"),
	(483, 26, "C", "Cochabamba"),
	(484, 26, "H", "Chuquisaca"),
	(485, 26, "L", "La Paz"),
	(486, 26, "N", "Pando"),
	(487, 26, "O", "Oruro"),
	(488, 26, "P", "Potosí"),
	(489, 26, "S", "Santa Cruz"),
	(490, 26, "T", "Tarija"),
	(491, 27, "01", "Unsko-sanski kanton"),
	(492, 27, "02", "Posavski kanton"),
	(493, 27, "03", "Tuzlanski kanton"),
	(494, 27, "04", "Zeničko-dobojski kanton"),
	(495, 27, "05", "Bosansko-podrinjski kanton"),
	(496, 27, "06", "Srednjobosanski kanton"),
	(497, 27, "07", "Hercegovačko-neretvanski kanton"),
	(498, 27, "08", "Zapadnohercegovački kanton"),
	(499, 27, "09", "Kanton Sarajevo"),
	(500, 27, "10", "Kanton br. 10 (Livanjski kanton)"),
	(501, 27, "BIH", "Federacija Bosna i Hercegovina"),
	(502, 27, "BRC", "Brčko distrikt"),
	(503, 27, "SRP", "Republika Srpska"),
	(504, 28, "CE", "Central"),
	(505, 28, "GH", "Ghanzi"),
	(506, 28, "KG", "Kgalagadi"),
	(507, 28, "KL", "Kgatleng"),
	(508, 28, "KW", "Kweneng"),
	(509, 28, "NE", "North-East"),
	(510, 28, "NW", "North-West"),
	(511, 28, "SE", "South-East"),
	(512, 28, "SO", "Southern"),
	(513, 30, "AC", "Acre"),
	(514, 30, "AL", "Alagoas"),
	(515, 30, "AM", "Amazonas"),
	(516, 30, "AP", "Amapá"),
	(517, 30, "BA", "Bahia"),
	(518, 30, "CE", "Ceará"),
	(519, 30, "DF", "Distrito Federal"),
	(520, 30, "ES", "Espírito Santo"),
	(521, 30, "GO", "Goiás"),
	(522, 30, "MA", "Maranhão"),
	(523, 30, "MG", "Minas Gerais"),
	(524, 30, "MS", "Mato Grosso do Sul"),
	(525, 30, "MT", "Mato Grosso"),
	(526, 30, "PA", "Pará"),
	(527, 30, "PB", "Paraíba"),
	(528, 30, "PE", "Pernambuco"),
	(529, 30, "PI", "Piauí"),
	(530, 30, "PR", "Paraná"),
	(531, 30, "RN", "Rio Grande do Norte"),
	(532, 30, "RJ", "Rio de Janeiro"),
	(533, 30, "RO", "Rondônia"),
	(534, 30, "RR", "Roraima"),
	(535, 30, "RS", "Rio Grande do Sul"),
	(536, 30, "SC", "Santa Catarina"),
	(537, 30, "SE", "Sergipe"),
	(538, 30, "SP", "São Paulo"),
	(539, 30, "TO", "Tocantins"),
	(540, 32, "BE", "Belait"),
	(541, 32, "BM", "Brunei-Muara"),
	(542, 32, "TE", "Temburong"),
	(543, 32, "TU", "Tutong"),
	(544, 33, "01", "Blagoevgrad"),
	(545, 33, "02", "Burgas"),
	(546, 33, "03", "Varna"),
	(547, 33, "04", "Veliko Tarnovo"),
	(548, 33, "05", "Vidin"),
	(549, 33, "06", "Vratsa"),
	(550, 33, "07", "Gabrovo"),
	(551, 33, "08", "Dobrich"),
	(552, 33, "09", "Kardzhali"),
	(553, 33, "10", "Kjustendil"),
	(554, 33, "11", "Lovech"),
	(555, 33, "12", "Montana"),
	(556, 33, "13", "Pazardzhik"),
	(557, 33, "14", "Pernik"),
	(558, 33, "15", "Pleven"),
	(559, 33, "16", "Plovdiv"),
	(560, 33, "17", "Razgrad"),
	(561, 33, "18", "Ruse"),
	(562, 33, "19", "Silistra"),
	(563, 33, "20", "Sliven"),
	(564, 33, "21", "Smolyan"),
	(565, 33, "22", "Sofia-Grad"),
	(566, 33, "23", "Sofia"),
	(567, 33, "24", "Stara Zagora"),
	(568, 33, "25", "Targovishte"),
	(569, 33, "26", "Haskovo"),
	(570, 33, "27", "Šumen"),
	(571, 33, "28", "Yambol"),
	(572, 34, "01", "Boucle du Mouhoun"),
	(573, 34, "02", "Cascades"),
	(574, 34, "03", "Centre"),
	(575, 34, "04", "Centre-Est"),
	(576, 34, "05", "Centre-Nord"),
	(577, 34, "06", "Centre-Ouest"),
	(578, 34, "07", "Centre-Sud"),
	(579, 34, "08", "Est"),
	(580, 34, "09", "Hauts-Bassins"),
	(581, 34, "10", "Nord"),
	(582, 34, "11", "Plateau-Central"),
	(583, 34, "12", "Sahel"),
	(584, 34, "13", "Sud-Ouest"),
	(585, 34, "BAL", "Balé"),
	(586, 34, "BAM", "Bam"),
	(587, 34, "BAN", "Banwa"),
	(588, 34, "BAZ", "Bazèga"),
	(589, 34, "BGR", "Bougouriba"),
	(590, 34, "BLG", "Boulgou"),
	(591, 34, "BLK", "Boulkiemdé"),
	(592, 34, "COM", "Comoé"),
	(593, 34, "GAN", "Ganzourgou"),
	(594, 34, "GNA", "Gnagna"),
	(595, 34, "GOU", "Gourma"),
	(596, 34, "HOU", "Houet"),
	(597, 34, "IOB", "Ioba"),
	(598, 34, "KAD", "Kadiogo"),
	(599, 34, "KEN", "Kénédougou"),
	(600, 34, "KMD", "Komondjari"),
	(601, 34, "KMP", "Kompienga"),
	(602, 34, "KOP", "Koulpélogo"),
	(603, 34, "KOS", "Kossi"),
	(604, 34, "KOT", "Kouritenga"),
	(605, 34, "KOW", "Kourwéogo"),
	(606, 34, "LER", "Léraba"),
	(607, 34, "LOR", "Loroum"),
	(608, 34, "MOU", "Mouhoun"),
	(609, 34, "NAM", "Namentenga"),
	(610, 34, "NAO", "Nahouri"),
	(611, 34, "NAY", "Nayala"),
	(612, 34, "NOU", "Noumbiel"),
	(613, 34, "OUB", "Oubritenga"),
	(614, 34, "OUD", "Oudalan"),
	(615, 34, "PAS", "Passoré"),
	(616, 34, "PON", "Poni"),
	(617, 34, "SEN", "Séno"),
	(618, 34, "SIS", "Sissili"),
	(619, 34, "SMT", "Sanmatenga"),
	(620, 34, "SNG", "Sanguié"),
	(621, 34, "SOM", "Soum"),
	(622, 34, "SOR", "Sourou"),
	(623, 34, "TAP", "Tapoa"),
	(624, 34, "TUI", "Tui"),
	(625, 34, "YAG", "Yagha"),
	(626, 34, "YAT", "Yatenga"),
	(627, 34, "ZIR", "Ziro"),
	(628, 34, "ZON", "Zondoma"),
	(629, 34, "ZOU", "Zoundwéogo"),
	(630, 35, "BB", "Bubanza"),
	(631, 35, "BL", "Bujumbura Rural"),
	(632, 35, "BM", "Bujumbura Mairie"),
	(633, 35, "BR", "Bururi"),
	(634, 35, "CA", "Cankuzo"),
	(635, 35, "CI", "Cibitoke"),
	(636, 35, "GI", "Gitega"),
	(637, 35, "KI", "Kirundo"),
	(638, 35, "KR", "Karuzi"),
	(639, 35, "KY", "Kayanza"),
	(640, 35, "MA", "Makamba"),
	(641, 35, "MU", "Muramvya"),
	(642, 35, "MW", "Mwaro"),
	(643, 35, "MY", "Muyinga"),
	(644, 35, "NG", "Ngozi"),
	(645, 35, "RT", "Rutana"),
	(646, 35, "RY", "Ruyigi"),
	(647, 36, "1", "Banteay Mean Chey [Bântéay Méanchey]"),
	(648, 36, "10", "Kracheh [Krâchéh]"),
	(649, 36, "11", "Mondol Kiri [Môndól Kiri]"),
	(650, 36, "12", "Phnom Penh [Phnum Pénh]"),
	(651, 36, "13", "Preah Vihear [Preah Vihéar]"),
	(652, 36, "14", "Prey Veaeng [Prey Vêng]"),
	(653, 36, "15", "Pousaat [Pouthisat]"),
	(654, 36, "16", "Rotanak Kiri [Rôtânôkiri]"),
	(655, 36, "17", "Siem Reab [Siemréab]"),
	(656, 36, "18", "Krong Preah Sihanouk [Krong Preah Sihanouk]"),
	(657, 36, "19", "Stueng Traeng [Stœ̆ng Trêng]"),
	(658, 36, "2", "Baat Dambang [Batdâmbâng]"),
	(659, 36, "20", "Svaay Rieng [Svay Rieng]"),
	(660, 36, "21", "Taakaev [Takêv]"),
	(661, 36, "22", "Otdar Mean Chey [Otdâr Méanchey] "),
	(662, 36, "23", "Krong Kaeb [Krong Kêb]"),
	(663, 36, "24", "Krong Pailin [Krong Pailin]"),
	(664, 36, "3", "Kampong Chaam [Kâmpóng Cham]"),
	(665, 36, "4", "Kampong Chhnang [Kâmpóng Chhnang]"),
	(666, 36, "5", "Kampong Spueu [Kâmpóng Spœ]"),
	(667, 36, "6", "Kampong Thum [Kâmpóng Thum]"),
	(668, 36, "7", "Kampot [Kâmpôt]"),
	(669, 36, "8", "Kandaal [Kândal]"),
	(670, 36, "9", "Kaoh Kong [Kaôh Kong]"),
	(671, 37, "AD", "Adamaoua"),
	(672, 37, "CE", "Centre"),
	(673, 37, "EN", "Far North"),
	(674, 37, "ES", "East"),
	(675, 37, "LT", "Littoral"),
	(676, 37, "NO", "North"),
	(677, 37, "NW", "North-West"),
	(678, 37, "OU", "West"),
	(679, 37, "SU", "South"),
	(680, 37, "SW", "South-West"),
	(681, 38, "AB", "Alberta"),
	(682, 38, "BC", "British Columbia"),
	(683, 38, "MB", "Manitoba"),
	(684, 38, "NB", "New Brunswick"),
	(685, 38, "NL", "Newfoundland and Labrador"),
	(686, 38, "NS", "Nova Scotia"),
	(687, 38, "NT", "Northwest Territories"),
	(688, 38, "NU", "Nunavut"),
	(689, 38, "ON", "Ontario"),
	(690, 38, "PE", "Prince Edward Island"),
	(691, 38, "QC", "Quebec"),
	(692, 38, "SK", "Saskatchewan"),
	(693, 38, "YT", "Yukon Territory"),
	(694, 39, "B", "Ilhas de Barlavento"),
	(695, 39, "BR", "Brava"),
	(696, 39, "BV", "Boa Vista"),
	(697, 39, "CA", "Santa Catarina"),
	(698, 39, "CF", "Santa Catarina do Fogo"),
	(699, 39, "CR", "Santa Cruz"),
	(700, 39, "MA", "Maio"),
	(701, 39, "MO", "Mosteiros"),
	(702, 39, "PA", "Paul"),
	(703, 39, "PN", "Porto Novo"),
	(704, 39, "PR", "Praia"),
	(705, 39, "RB", "Ribeira Brava"),
	(706, 39, "RG", "Ribeira Grande"),
	(707, 39, "RS", "Ribeira Grande de Santiago"),
	(708, 39, "S", "Ilhas de Sotavento"),
	(709, 39, "SD", "São Domingos"),
	(710, 39, "SF", "São Filipe"),
	(711, 39, "SL", "Sal"),
	(712, 39, "SM", "São Miguel"),
	(713, 39, "SO", "São Lourenço dos Órgãos"),
	(714, 39, "SS", "São Salvador do Mundo"),
	(715, 39, "SV", "São Vicente"),
	(716, 39, "TA", "Tarrafal"),
	(717, 39, "TS", "Tarrafal de São Nicolau"),
	(718, 40, "01~", "Bodden Town"),
	(719, 40, "02~", "Cayman Brac"),
	(720, 40, "03~", "East End"),
	(721, 40, "04~", "George Town"),
	(722, 40, "05~", "Little Cayman"),
	(723, 40, "06~", "North Side"),
	(724, 40, "07~", "West Bay"),
	(725, 41, "AC", "Ouham"),
	(726, 41, "BB", "Bamingui-Bangoran"),
	(727, 41, "BGF", "Bangui"),
	(728, 41, "BK", "Basse-Kotto"),
	(729, 41, "HK", "Haute-Kotto"),
	(730, 41, "HM", "Haut-Mbomou"),
	(731, 41, "HS", "Haute-Sangha / Mambéré-Kadéï"),
	(732, 41, "KB", "Gribingui"),
	(733, 41, "KG", "Kémo-Gribingui"),
	(734, 41, "LB", "Lobaye"),
	(735, 41, "MB", "Mbomou"),
	(736, 41, "MP", "Ombella-Mpoko"),
	(737, 41, "NM", "Nana-Mambéré"),
	(738, 41, "OP", "Ouham-Pendé"),
	(739, 41, "SE", "Sangha"),
	(740, 41, "UK", "Ouaka"),
	(741, 41, "VK", "Vakaga"),
	(742, 42, "BA", "Al Baṭḩah"),
	(743, 42, "BG", "Baḩr al Ghazāl"),
	(744, 42, "BO", "Būrkū"),
	(745, 42, "CB", "Shārī Bāqirmī"),
	(746, 42, "EN", "Innīdī"),
	(747, 42, "GR", "Qīrā"),
	(748, 42, "HL", "Ḥajjar Lamīs"),
	(749, 42, "KA", "Kānim"),
	(750, 42, "LC", "Al Buḩayrah"),
	(751, 42, "LO", "Lūqūn al Gharbī"),
	(752, 42, "LR", "Lūqūn ash Sharqī"),
	(753, 42, "MA", "Māndūl"),
	(754, 42, "MC", "Shārī al Awsaṭ"),
	(755, 42, "ME", "Māyū Kībbī ash Sharqī"),
	(756, 42, "MO", "Māyū Kībbī al Gharbī"),
	(757, 42, "ND", "Madīnat Injamīnā"),
	(758, 42, "OD", "Waddāy"),
	(759, 42, "SA", "Salāmāt"),
	(760, 42, "SI", "Sīlā"),
	(761, 42, "TA", "Tānjilī"),
	(762, 42, "TI", "Tibastī"),
	(763, 42, "WF", "Wādī Fīrā"),
	(764, 43, "I", "I Región de Tarapacá"),
	(765, 43, "II", "II Región de Antofagasta"),
	(766, 43, "III", "III Región de Atacama"),
	(767, 43, "IV", "IV Región de Coquimbo"),
	(768, 43, "IX", "IX Región de la Araucanía"),
	(769, 43, "RM", "Región Metropolitana de Santiago"),
	(770, 43, "V", "V Región de Valaparaíso"),
	(771, 43, "VI", "VI Región de L. B. OŽhiggins"),
	(772, 43, "VII", "VII Región del Maule"),
	(773, 43, "VIII", "VIII Región del Bío Bío"),
	(774, 43, "X", "X Región de los Lagos"),
	(775, 43, "XI", "XI Región de Aysén"),
	(776, 43, "XII", "XII Región de Magallanes"),
	(777, 44, "AH", "Anhui Province"),
	(778, 44, "BJ", "Beijing Municipality"),
	(779, 44, "CQ", "Chongqing Municipality"),
	(780, 44, "FJ", "Fujian Province"),
	(781, 44, "GD", "Guangdong Province"),
	(782, 44, "GS", "Gansu Province"),
	(783, 44, "GX", "Guangxi Zhuang Autonomous Region"),
	(784, 44, "GZ", "Guizhou Province"),
	(785, 44, "HA", "Henan Province"),
	(786, 44, "HB", "Hubei Province"),
	(787, 44, "HE", "Hebei Province"),
	(788, 44, "HI", "Hainan Province"),
	(789, 44, "HK", "Hong Kong Special Administrative Region (Xianggang Special Administrative Region)"),
	(790, 44, "HL", "Heilongjiang Province"),
	(791, 44, "HN", "Hunan Province"),
	(792, 44, "JL", "Jilin Province"),
	(793, 44, "JS", "Jiangsu Province"),
	(794, 44, "JX", "Jiangxi Province"),
	(795, 44, "LN", "Liaoning Province"),
	(796, 44, "MC", "Macau Special Administrative Region (Aomen Special Administrative Region)"),
	(797, 44, "NM", "Inner Mongolia Autonomous Region (Nei Mongol Autonomous Region)"),
	(798, 44, "NX", "Ningxia Hui Autonomous Region"),
	(799, 44, "QH", "Qinghai Province"),
	(800, 44, "SC", "Sichuan Province"),
	(801, 44, "SD", "Shandong Province"),
	(802, 44, "SH", "Shanghai Municipality"),
	(803, 44, "SN", "Shaanxi Province"),
	(804, 44, "SX", "Shanxi Province"),
	(805, 44, "TJ", "Tianjin Municipality"),
	(806, 44, "XJ", "Xinjiang Uyghur Autonomous Region"),
	(807, 44, "XZ", "Tibet Autonomous Region (Xizang Autonomous Region)"),
	(808, 44, "YN", "Yunnan Province"),
	(809, 44, "ZJ", "Zhejiang Province"),
	(810, 47, "AMA", "Amazonas"),
	(811, 47, "ANT", "Antioquia"),
	(812, 47, "ARA", "Arauca"),
	(813, 47, "ATL", "Atlántico"),
	(814, 47, "BOL", "Bolívar"),
	(815, 47, "BOY", "Boyacá"),
	(816, 47, "CAL", "Caldas"),
	(817, 47, "CAQ", "Caquetá"),
	(818, 47, "CAS", "Casanare"),
	(819, 47, "CAU", "Cauca"),
	(820, 47, "CES", "Cesar"),
	(821, 47, "CHO", "Chocó"),
	(822, 47, "COR", "Córdoba"),
	(823, 47, "CUN", "Cundinamarca"),
	(824, 47, "GUA", "Guainía"),
	(825, 47, "GUV", "Guaviare"),
	(826, 47, "HUI", "Huila"),
	(827, 47, "LAG", "La Guajira"),
	(828, 47, "MAG", "Magdalena"),
	(829, 47, "MET", "Meta"),
	(830, 47, "NAR", "Nariño"),
	(831, 47, "NDS", "Norte de Santander"),
	(832, 47, "PUT", "Putumayo"),
	(833, 47, "QUI", "Quindío"),
	(834, 47, "RIS", "Risaralda"),
	(835, 47, "SAI", "San Andres Islas"),
	(836, 47, "SAN", "Santander"),
	(837, 47, "SUC", "Sucre"),
	(838, 47, "TOL", "Tolima"),
	(839, 47, "VAL", "Valle"),
	(840, 47, "VAU", "Vaupés"),
	(841, 47, "VIC", "Vichada"),
	(842, 48, "A", "Andjouân (Anjwān)"),
	(843, 48, "G", "Andjazîdja"),
	(844, 48, "M", "Moûhîlî (Mūhīlī)"),
	(845, 49, "11", "Bouenza"),
	(846, 49, "12", "Pool"),
	(847, 49, "13", "Sangha"),
	(848, 49, "14", "Plateaux"),
	(849, 49, "15", "Cuvette-Ouest"),
	(850, 49, "2", "Lékoumou"),
	(851, 49, "5", "Kouilou"),
	(852, 49, "7", "Likouala"),
	(853, 49, "8", "Cuvette"),
	(854, 49, "9", "Niari"),
	(855, 49, "BZV", "Brazzaville"),
	(856, 51, "A", "Alajuela"),
	(857, 51, "C", "Cartago"),
	(858, 51, "G", "Guanacaste"),
	(859, 51, "H", "Heredia"),
	(860, 51, "L", "Limón"),
	(861, 51, "P", "Puntarenas"),
	(862, 51, "SJ", "San José"),
	(863, 52, "01", "Lagunes (Région des)"),
	(864, 52, "02", "Haut-Sassandra (Région du)"),
	(865, 52, "03", "Savanes (Région des)"),
	(866, 52, "04", "Vallée du Bandama (Région de la)"),
	(867, 52, "05", "Moyen-Comoé (Région du)"),
	(868, 52, "06", "18 Montagnes (Région des)"),
	(869, 52, "07", "Lacs (Région des)"),
	(870, 52, "08", "Zanzan (Région du)"),
	(871, 52, "09", "Bas-Sassandra (Région du)"),
	(872, 52, "10", "Denguélé (Région du)"),
	(873, 52, "11", "Nzi-Comoé (Région)"),
	(874, 52, "12", "Marahoué (Région de la)"),
	(875, 52, "13", "Sud-Comoé (Région du)"),
	(876, 52, "14", "Worodougou (Région du)"),
	(877, 52, "15", "Sud-Bandama (Région du)"),
	(878, 52, "16", "Agnébi (Région de l')"),
	(879, 52, "17", "Bafing (Région du)"),
	(880, 52, "18", "Fromager (Région du)"),
	(881, 52, "19", "Moyen-Cavally (Région du)"),
	(882, 53, "01", "Zagrebacka županija"),
	(883, 53, "02", "Krapinsko-zagorska županija"),
	(884, 53, "03", "Sisacko-moslavacka županija"),
	(885, 53, "04", "Karlovacka županija"),
	(886, 53, "05", "Varaždinska županija"),
	(887, 53, "06", "Koprivnicko-križevacka županija"),
	(888, 53, "07", "Bjelovarsko-bilogorska županija"),
	(889, 53, "08", "Primorsko-goranska županija"),
	(890, 53, "09", "Licko-senjska županija"),
	(891, 53, "10", "Viroviticko-podravska županija"),
	(892, 53, "11", "Požeško-slavonska županija"),
	(893, 53, "12", "Brodsko-posavska županija"),
	(894, 53, "13", "Zadarska županija"),
	(895, 53, "14", "Osjecko-baranjska županija"),
	(896, 53, "15", "Šibensko-kninska županija"),
	(897, 53, "16", "Vukovarsko-srijemska županija"),
	(898, 53, "17", "Splitsko-dalmatinska županija"),
	(899, 53, "18", "Istarska županija"),
	(900, 53, "19", "Dubrovacko-neretvanska županija"),
	(901, 53, "20", "Medimurska županija"),
	(902, 53, "21", "Grad Zagreb"),
	(903, 54, "01", "Pinar del Río"),
	(904, 54, "02", "La Habana"),
	(905, 54, "03", "Ciudad de La Habana"),
	(906, 54, "04", "Matanzas"),
	(907, 54, "05", "Villa Clara"),
	(908, 54, "06", "Cienfuegos"),
	(909, 54, "07", "Sancti Spíritus"),
	(910, 54, "08", "Ciego de Ávila"),
	(911, 54, "09", "Camagüey"),
	(912, 54, "10", "Las Tunas"),
	(913, 54, "11", "Holguín"),
	(914, 54, "12", "Granma"),
	(915, 54, "13", "Santiago de Cuba"),
	(916, 54, "14", "Guantánamo"),
	(917, 54, "99", "Isla de la Juventud"),
	(918, 55, "01", "Lefkosia"),
	(919, 55, "02", "Lemesos"),
	(920, 55, "03", "Larnaka"),
	(921, 55, "04", "Ammochostos"),
	(922, 55, "05", "Pafos"),
	(923, 55, "06", "Keryneia"),
	(924, 56, "101", "Praha 1"),
	(925, 56, "102", "Praha 2"),
	(926, 56, "103", "Praha 3"),
	(927, 56, "104", "Praha 4"),
	(928, 56, "105", "Praha 5"),
	(929, 56, "106", "Praha 6"),
	(930, 56, "107", "Praha 7"),
	(931, 56, "108", "Praha 8"),
	(932, 56, "109", "Praha 9"),
	(933, 56, "10A", "Praha 10"),
	(934, 56, "10B", "Praha 11"),
	(935, 56, "10C", "Praha 12"),
	(936, 56, "10D", "Praha 13"),
	(937, 56, "10E", "Praha 14"),
	(938, 56, "10F", "Praha 15"),
	(939, 56, "201 ", "Benešov "),
	(940, 56, "202 ", "Beroun "),
	(941, 56, "203 ", "Kladno "),
	(942, 56, "204 ", "Kolín "),
	(943, 56, "205 ", "Kutná Hora "),
	(944, 56, "206 ", "Mělník "),
	(945, 56, "207 ", "Mladá Boleslav "),
	(946, 56, "208 ", "Nymburk "),
	(947, 56, "209 ", "Praha východ "),
	(948, 56, "20A ", "Praha západ "),
	(949, 56, "20B ", "Příbram "),
	(950, 56, "20C ", "Rakovník "),
	(951, 56, "311 ", "České Budějovice "),
	(952, 56, "312 ", "Český Krumlov "),
	(953, 56, "313 ", "Jindřichův Hradec "),
	(954, 56, "314 ", "Písek "),
	(955, 56, "315 ", "Prachatice "),
	(956, 56, "316 ", "Strakonice "),
	(957, 56, "317 ", "Tábor "),
	(958, 56, "321 ", "Domažlice "),
	(959, 56, "322 ", "Klatovy "),
	(960, 56, "323 ", "Plzeň město "),
	(961, 56, "324 ", "Plzeň jih "),
	(962, 56, "325 ", "Plzeň sever "),
	(963, 56, "326 ", "Rokycany "),
	(964, 56, "327 ", "Tachov "),
	(965, 56, "411 ", "Cheb "),
	(966, 56, "412 ", "Karlovy Vary "),
	(967, 56, "413 ", "Sokolov "),
	(968, 56, "421 ", "Děčín "),
	(969, 56, "422 ", "Chomutov "),
	(970, 56, "423 ", "Litoměřice "),
	(971, 56, "424 ", "Louny "),
	(972, 56, "425 ", "Most "),
	(973, 56, "426 ", "Teplice "),
	(974, 56, "427 ", "Ústí nad Labem "),
	(975, 56, "511 ", "Česká Lípa "),
	(976, 56, "512 ", "Jablonec nad Nisou "),
	(977, 56, "513 ", "Liberec "),
	(978, 56, "514 ", "Semily "),
	(979, 56, "521 ", "Hradec Králové "),
	(980, 56, "522 ", "Jičín "),
	(981, 56, "523 ", "Náchod "),
	(982, 56, "524 ", "Rychnov nad Kněžnou "),
	(983, 56, "525 ", "Trutnov "),
	(984, 56, "531 ", "Chrudim "),
	(985, 56, "532 ", "Pardubice "),
	(986, 56, "533 ", "Svitavy "),
	(987, 56, "534 ", "Ústí nad Orlicí "),
	(988, 56, "611 ", "Havlíčkův Brod "),
	(989, 56, "612 ", "Jihlava "),
	(990, 56, "613 ", "Pelhřimov "),
	(991, 56, "614 ", "Třebíč "),
	(992, 56, "615 ", "Žd’ár nad Sázavou "),
	(993, 56, "621 ", "Blansko "),
	(994, 56, "622 ", "Brno-město "),
	(995, 56, "623 ", "Brno-venkov "),
	(996, 56, "624 ", "Břeclav "),
	(997, 56, "625 ", "Hodonín "),
	(998, 56, "626 ", "Vyškov "),
	(999, 56, "627 ", "Znojmo "),
	(1000, 56, "711 ", "Jeseník "),
	(1001, 56, "712 ", "Olomouc "),
	(1002, 56, "713 ", "Prostĕjov "),
	(1003, 56, "714 ", "Přerov "),
	(1004, 56, "715 ", "Šumperk "),
	(1005, 56, "721 ", "Kromĕříž "),
	(1006, 56, "722 ", "Uherské Hradištĕ "),
	(1007, 56, "723 ", "Vsetín "),
	(1008, 56, "724 ", "Zlín "),
	(1009, 56, "801 ", "Bruntál "),
	(1010, 56, "802 ", "Frýdek Místek "),
	(1011, 56, "803 ", "Karviná "),
	(1012, 56, "804 ", "Nový Jičín "),
	(1013, 56, "805 ", "Opava "),
	(1014, 56, "806 ", "Ostrava město "),
	(1015, 56, "JC", "Jihoceský kraj"),
	(1016, 56, "JM", "Jihomoravský kraj "),
	(1017, 56, "KA", "Karlovarský kraj"),
	(1018, 56, "KR", "Královéhradecký kraj"),
	(1019, 56, "LI", "Liberecký kraj"),
	(1020, 56, "MO", "Moravskoslezský kraj"),
	(1021, 56, "OL", "Olomoucký kraj"),
	(1022, 56, "PA", "Pardubický kraj"),
	(1023, 56, "PL", "Plzenský kraj"),
	(1024, 56, "PR", "Praha, hlavní mesto"),
	(1025, 56, "ST", "Stredoceský kraj"),
	(1026, 56, "US", "Ústecký kraj "),
	(1027, 56, "VY", "Vysocina"),
	(1028, 56, "ZL", "Zlínský kraj"),
	(1029, 57, "81", "North Jutland"),
	(1030, 57, "82", "Central Jutland"),
	(1031, 57, "83", "South Denmark"),
	(1032, 57, "84", "Capital"),
	(1033, 57, "85", "Zeeland"),
	(1034, 58, "AR", "Arta"),
	(1035, 58, "AS", "Ali Sabieh"),
	(1036, 58, "DI", "Dikhil"),
	(1037, 58, "DJ", "Djibouti"),
	(1038, 58, "OB", "Obock"),
	(1039, 58, "TA", "Tadjourah"),
	(1040, 59, "02", "Saint Andrew"),
	(1041, 59, "03", "Saint David"),
	(1042, 59, "04", "Saint George"),
	(1043, 59, "05", "Saint John"),
	(1044, 59, "06", "Saint Joseph"),
	(1045, 59, "07", "Saint Luke"),
	(1046, 59, "08", "Saint Mark"),
	(1047, 59, "09", "Saint Patrick"),
	(1048, 59, "10", "Saint Paul"),
	(1049, 59, "11", "Saint Peter"),
	(1050, 60, "01", "Distrito Nacional (Santo Domingo)"),
	(1051, 60, "02", "Azua"),
	(1052, 60, "03", "Bahoruco"),
	(1053, 60, "04", "Barahona"),
	(1054, 60, "05", "Dajabón"),
	(1055, 60, "06", "Duarte"),
	(1056, 60, "07", "La Estrelleta [Elías Piña]"),
	(1057, 60, "08", "El Seybo [El Seibo]"),
	(1058, 60, "09", "Espaillat"),
	(1059, 60, "10", "Independencia"),
	(1060, 60, "11", "La Altagracia"),
	(1061, 60, "12", "La Romana"),
	(1062, 60, "13", "La Vega"),
	(1063, 60, "14", "María Trinidad Sánchez"),
	(1064, 60, "15", "Monte Cristi"),
	(1065, 60, "16", "Pedernales"),
	(1066, 60, "17", "Peravia"),
	(1067, 60, "18", "Puerto Plata"),
	(1068, 60, "19", "Salcedo"),
	(1069, 60, "20", "Samaná"),
	(1070, 60, "21", "San Cristóbal"),
	(1071, 60, "22", "San Juan"),
	(1072, 60, "23", "San Pedro de Macorís"),
	(1073, 60, "24", "Sánchez Ramírez"),
	(1074, 60, "25", "Santiago"),
	(1075, 60, "26", "Santiago Rodríguez"),
	(1076, 60, "27", "Valverde"),
	(1077, 60, "28", "Monseñor Nouel"),
	(1078, 60, "29", "Monte Plata"),
	(1079, 60, "30", "Hato Mayor"),
	(1080, 60, "31", "San Jose de Ocoa"),
	(1081, 60, "32", "Santo Domingo"),
	(1082, 62, "A", "Azuay"),
	(1083, 62, "B", "Bolívar"),
	(1084, 62, "C", "Carchi"),
	(1085, 62, "D", "Orellana"),
	(1086, 62, "E", "Esmeraldas"),
	(1087, 62, "F", "Cañar"),
	(1088, 62, "G", "Guayas"),
	(1089, 62, "H", "Chimborazo"),
	(1090, 62, "I", "Imbabura"),
	(1091, 62, "L", "Loja"),
	(1092, 62, "M", "Manabí"),
	(1093, 62, "N", "Napo"),
	(1094, 62, "O", "El Oro"),
	(1095, 62, "P", "Pichincha"),
	(1096, 62, "R", "Los Ríos"),
	(1097, 62, "S", "Morona-Santiago"),
	(1098, 62, "SD", "Santo Domingo de los Tsachilas"),
	(1099, 62, "SE", "Santa Elena"),
	(1100, 62, "T", "Tungurahua"),
	(1101, 62, "U", "Sucumbíos"),
	(1102, 62, "W", "Galápagos"),
	(1103, 62, "X", "Cotopaxi"),
	(1104, 62, "Y", "Pastaza"),
	(1105, 62, "Z", "Zamora-Chinchipe"),
	(1106, 63, "ALX", "Al Iskandariyah"),
	(1107, 63, "ASN", "Aswan"),
	(1108, 63, "AST", "Asyut"),
	(1109, 63, "BA", "Al Bahr al Ahmar"),
	(1110, 63, "BH", "Al Buhayrah"),
	(1111, 63, "BNS", "Bani Suwayf"),
	(1112, 63, "C", "Al Qahirah"),
	(1113, 63, "DK", "Ad Daqahliyah"),
	(1114, 63, "DT", "Dumyat"),
	(1115, 63, "FYM", "Al Fayyum"),
	(1116, 63, "GH", "Al Gharbiyah"),
	(1117, 63, "GZ", "Al Jizah"),
	(1118, 63, "HU", "Ḩulwān"),
	(1119, 63, "IS", "Al Ismā`īlīyah"),
	(1120, 63, "JS", "Janub Sina'"),
	(1121, 63, "KB", "Al Qalyubiyah"),
	(1122, 63, "KFS", "Kafr ash Shaykh"),
	(1123, 63, "KN", "Qina"),
	(1124, 63, "LX", "al-Uqsur"),
	(1125, 63, "MN", "Al Minya"),
	(1126, 63, "MNF", "Al Minufiyah"),
	(1127, 63, "MT", "Matrūh"),
	(1128, 63, "PTS", "Būr Sa`īd"),
	(1129, 63, "SHG", "Suhaj"),
	(1130, 63, "SHR", "Ash Sharqiyah"),
	(1131, 63, "SIN", "Shamal Sina'"),
	(1132, 63, "SU", "As Sādis min Uktūbar"),
	(1133, 63, "SUZ", "As Suways"),
	(1134, 63, "WAD", "Al Wadi al Jadid"),
	(1135, 64, "AH", "Ahuachapán"),
	(1136, 64, "CA", "Cabañas"),
	(1137, 64, "CH", "Chalatenango"),
	(1138, 64, "CU", "Cuscatlán"),
	(1139, 64, "LI", "La Libertad"),
	(1140, 64, "MO", "Morazán"),
	(1141, 64, "PA", "La Paz"),
	(1142, 64, "SA", "Santa Ana"),
	(1143, 64, "SM", "San Miguel"),
	(1144, 64, "SO", "Sonsonate"),
	(1145, 64, "SS", "San Salvador"),
	(1146, 64, "SV", "San Vicente"),
	(1147, 64, "UN", "La Unión"),
	(1148, 64, "US", "Usulután"),
	(1149, 65, "AN", "Annobón"),
	(1150, 65, "BN", "Bioko Norte"),
	(1151, 65, "BS", "Bioko Sur"),
	(1152, 65, "C", "Región Continental"),
	(1153, 65, "CS", "Centro Sur"),
	(1154, 65, "I", "Región Insular"),
	(1155, 65, "KN", "Kie-Ntem"),
	(1156, 65, "LI", "Litoral"),
	(1157, 65, "WN", "Wele-Nzás"),
	(1158, 66, "AN", "Anseba"),
	(1159, 66, "DK", "Debubawi K’eyyĭḥ Baḥri"),
	(1160, 66, "DU", "Debub"),
	(1161, 66, "GB", "Gash-Barka"),
	(1162, 66, "MA", "Ma’ĭkel"),
	(1163, 66, "SK", "Semienawi K’eyyĭḥ Baḥri"),
	(1164, 67, "37", "Harjumaa"),
	(1165, 67, "39", "Hiiumaa"),
	(1166, 67, "44", "Ida-Virumaa"),
	(1167, 67, "49", "Jõgevamaa"),
	(1168, 67, "51", "Järvamaa"),
	(1169, 67, "57", "Läänemaa"),
	(1170, 67, "59", "Lääne-Virumaa"),
	(1171, 67, "65", "Põlvamaa"),
	(1172, 67, "67", "Pärnumaa"),
	(1173, 67, "70", "Raplamaa"),
	(1174, 67, "74", "Saaremaa"),
	(1175, 67, "78", "Tartumaa"),
	(1176, 67, "82", "Valgamaa"),
	(1177, 67, "84", "Viljandimaa"),
	(1178, 67, "86", "Võrumaa"),
	(1179, 68, "AA", "Adis Abeba"),
	(1180, 68, "AF", "Afar"),
	(1181, 68, "AM", "Amara"),
	(1182, 68, "BE", "Binshangul Gumuz"),
	(1183, 68, "DD", "Dire Dawa"),
	(1184, 68, "GA", "Gambela Hizboch"),
	(1185, 68, "HA", "Hareri Hizb"),
	(1186, 68, "OR", "Oromiya"),
	(1187, 68, "SN", "YeDebub Biheroch Bihereseboch na Hizboch"),
	(1188, 68, "SO", "Sumale"),
	(1189, 68, "TI", "Tigray"),
	(1190, 71, "C", "Central"),
	(1191, 71, "E", "Eastern"),
	(1192, 71, "N", "Northern"),
	(1193, 71, "R", "Rotuma"),
	(1194, 71, "W", "Western"),
	(1195, 72, "01", "Ahvenanmaan maakunta"),
	(1196, 72, "02", "Etelä-Karjala"),
	(1197, 72, "03", "Etelä-Pohjanmaa"),
	(1198, 72, "04", "Etelä-Savo"),
	(1199, 72, "05", "Kainuu"),
	(1200, 72, "06", "Kanta-Häme"),
	(1201, 72, "07", "Keski-Pohjanmaa"),
	(1202, 72, "08", "Keski-Suomi"),
	(1203, 72, "09", "Kymenlaakso"),
	(1204, 72, "10", "Lappi"),
	(1205, 72, "11", "Pirkanmaa"),
	(1206, 72, "12", "Pohjanmaa"),
	(1207, 72, "13", "Pohjois-Karjala"),
	(1208, 72, "14", "Pohjois-Pohjanmaa"),
	(1209, 72, "15", "Pohjois-Savo"),
	(1210, 72, "16", "Päijät-Häme"),
	(1211, 72, "17", "Satakunta"),
	(1212, 72, "18", "Uusimaa"),
	(1213, 72, "19", "Varsinais-Suomi"),
	(1214, 73, "01", "Ain"),
	(1215, 73, "02", "Aisne"),
	(1216, 73, "03", "Allier"),
	(1217, 73, "04", "Alpes-de-Haute-Provence"),
	(1218, 73, "05", "Hautes-Alpes"),
	(1219, 73, "06", "Alpes-Maritimes"),
	(1220, 73, "07", "Ardèche"),
	(1221, 73, "08", "Ardennes"),
	(1222, 73, "09", "Ariège"),
	(1223, 73, "10", "Aube"),
	(1224, 73, "11", "Aude"),
	(1225, 73, "12", "Aveyron"),
	(1226, 73, "13", "Bouches-du-Rhône"),
	(1227, 73, "14", "Calvados"),
	(1228, 73, "15", "Cantal"),
	(1229, 73, "16", "Charente"),
	(1230, 73, "17", "Charente-Maritime"),
	(1231, 73, "18", "Cher"),
	(1232, 73, "19", "Corrèze"),
	(1233, 73, "21", "Côte-d'Or"),
	(1234, 73, "22", "Côtes-d'Armor"),
	(1235, 73, "23", "Creuse"),
	(1236, 73, "24", "Dordogne"),
	(1237, 73, "25", "Doubs"),
	(1238, 73, "26", "Drôme"),
	(1239, 73, "27", "Eure"),
	(1240, 73, "28", "Eure-et-Loir"),
	(1241, 73, "29", "Finistère"),
	(1242, 73, "2A", "Corse-du-Sud"),
	(1243, 73, "2B", "Haute-Corse"),
	(1244, 73, "30", "Gard"),
	(1245, 73, "31", "Haute-Garonne"),
	(1246, 73, "32", "Gers"),
	(1247, 73, "33", "Gironde"),
	(1248, 73, "34", "Hérault"),
	(1249, 73, "35", "Ille-et-Vilaine"),
	(1250, 73, "36", "Indre"),
	(1251, 73, "37", "Indre-et-Loire"),
	(1252, 73, "38", "Isère"),
	(1253, 73, "39", "Jura"),
	(1254, 73, "40", "Landes"),
	(1255, 73, "41", "Loir-et-Cher"),
	(1256, 73, "42", "Loire"),
	(1257, 73, "43", "Haute-Loire"),
	(1258, 73, "44", "Loire-Atlantique"),
	(1259, 73, "45", "Loiret"),
	(1260, 73, "46", "Lot"),
	(1261, 73, "47", "Lot-et-Garonne"),
	(1262, 73, "48", "Lozère"),
	(1263, 73, "49", "Maine-et-Loire"),
	(1264, 73, "50", "Manche"),
	(1265, 73, "51", "Marne"),
	(1266, 73, "52", "Haute-Marne"),
	(1267, 73, "53", "Mayenne"),
	(1268, 73, "54", "Meurthe-et-Moselle"),
	(1269, 73, "55", "Meuse"),
	(1270, 73, "56", "Morbihan"),
	(1271, 73, "57", "Moselle"),
	(1272, 73, "58", "Nièvre"),
	(1273, 73, "59", "Nord"),
	(1274, 73, "60", "Oise"),
	(1275, 73, "61", "Orne"),
	(1276, 73, "62", "Pas-de-Calais"),
	(1277, 73, "63", "Puy-de-Dôme"),
	(1278, 73, "64", "Pyrénées-Atlantiques"),
	(1279, 73, "65", "Hautes-Pyrénées"),
	(1280, 73, "66", "Pyrénées-Orientales"),
	(1281, 73, "67", "Bas-Rhin"),
	(1282, 73, "68", "Haut-Rhin"),
	(1283, 73, "69", "Rhône"),
	(1284, 73, "70", "Haute-Saône"),
	(1285, 73, "71", "Saône-et-Loire"),
	(1286, 73, "72", "Sarthe"),
	(1287, 73, "73", "Savoie"),
	(1288, 73, "74", "Haute-Savoie"),
	(1289, 73, "75", "Paris"),
	(1290, 73, "76", "Seine-Maritime"),
	(1291, 73, "77", "Seine-et-Marne"),
	(1292, 73, "78", "Yvelines"),
	(1293, 73, "79", "Deux-Sèvres"),
	(1294, 73, "80", "Somme"),
	(1295, 73, "81", "Tarn"),
	(1296, 73, "82", "Tarn-et-Garonne"),
	(1297, 73, "83", "Var"),
	(1298, 73, "84", "Vaucluse"),
	(1299, 73, "85", "Vendée"),
	(1300, 73, "86", "Vienne"),
	(1301, 73, "87", "Haute-Vienne"),
	(1302, 73, "88", "Vosges"),
	(1303, 73, "89", "Yonne"),
	(1304, 73, "90", "Territoire de Belfort"),
	(1305, 73, "91", "Essonne"),
	(1306, 73, "92", "Hauts-de-Seine"),
	(1307, 73, "93", "Seine-Saint-Denis"),
	(1308, 73, "94", "Val-de-Marne"),
	(1309, 73, "95", "Val-d'Oise"),
	(1310, 73, "971 (DOM)", "Guadeloupe"),
	(1311, 73, "972 (DOM)", "Martinique"),
	(1312, 73, "973 (DOM)", "Guyane"),
	(1313, 73, "974 (DOM)", "Saint Denis"),
	(1314, 73, "975 (DOM)", "St-Pierre de Miquelon"),
	(1315, 73, "976 (TOM)", "Mayotte"),
	(1316, 73, "984 (TOM)", "Terres australes et Antartiques"),
	(1317, 73, "985 (TOM)", "Nouvelle-Calédonie"),
	(1318, 73, "986 (TOM)", "Wallis et Futuna"),
	(1319, 73, "987 (TOM)", "Polynésie française"),
	(1320, 73, "Et", "Etranger"),
	(1321, 77, "X1~", "Ile Saint-Paul et Ile Amsterdam"),
	(1322, 77, "X2~", "Crozet Islands"),
	(1323, 77, "X3~", "Kerguelen"),
	(1324, 77, "X4~", "Iles Eparses"),
	(1325, 78, "1", "Estuaire"),
	(1326, 78, "2", "Haut-Ogooué"),
	(1327, 78, "3", "Moyen-Ogooué"),
	(1328, 78, "4", "Ngounié"),
	(1329, 78, "5", "Nyanga"),
	(1330, 78, "6", "Ogooué-Ivindo"),
	(1331, 78, "7", "Ogooué-Lolo"),
	(1332, 78, "8", "Ogooué-Maritime"),
	(1333, 78, "9", "Woleu-Ntem"),
	(1334, 79, "B", "Banjul"),
	(1335, 79, "L", "Lower River"),
	(1336, 79, "M", "MacCarthy Island"),
	(1337, 79, "N", "North Bank"),
	(1338, 79, "U", "Upper River"),
	(1339, 79, "W", "Western"),
	(1340, 80, "AB", "Abkhazia"),
	(1341, 80, "AJ", "Ajaria"),
	(1342, 80, "GU", "Guria"),
	(1343, 80, "IM", "Imereti"),
	(1344, 80, "KA", "Kakheti"),
	(1345, 80, "KK", "Kvemo Kartli"),
	(1346, 80, "MM", "Mtskheta-Mtianeti"),
	(1347, 80, "RL", "Racha-Lechkhumi [and] Kvemo Svaneti"),
	(1348, 80, "SJ", "Samtskhe-Javakheti"),
	(1349, 80, "SK", "Shida Kartli"),
	(1350, 80, "SZ", "Samegrelo-Zemo Svaneti"),
	(1351, 80, "TB", "Tbilisi"),
	(1352, 81, "BAW", "Baden-Württemberg"),
	(1353, 81, "BAY", "Bayern"),
	(1354, 81, "BER", "Berlin"),
	(1355, 81, "BRE", "Bremen"),
	(1356, 81, "BRG", "Brandenburg"),
	(1357, 81, "HAM", "Hamburg"),
	(1358, 81, "HES", "Hessen"),
	(1359, 81, "MEC", "Mecklenburg-Vorpommern"),
	(1360, 81, "NDS", "Niedersachsen"),
	(1361, 81, "NRW", "Nordrhein-Westfalen"),
	(1362, 81, "RHE", "Rheinland-Pfalz"),
	(1363, 81, "SAC", "Sachsen-Anhalt"),
	(1364, 81, "SAR", "Saarland"),
	(1365, 81, "SAS", "Sachsen"),
	(1366, 81, "SCN", "Schleswig-Holstein"),
	(1367, 81, "THE", "Thüringen"),
	(1368, 82, "AA", "Greater Accra"),
	(1369, 82, "AH", "Ashanti"),
	(1370, 82, "BA", "Brong-Ahafo"),
	(1371, 82, "CP", "Central"),
	(1372, 82, "EP", "Eastern"),
	(1373, 82, "NP", "Northern"),
	(1374, 82, "TV", "Volta"),
	(1375, 82, "UE", "Upper East"),
	(1376, 82, "UW", "Upper West"),
	(1377, 82, "WP", "Western"),
	(1378, 84, "01", "Aitolia kai Akarnania"),
	(1379, 84, "03", "Voiotia"),
	(1380, 84, "04", "Evvoia"),
	(1381, 84, "05", "Evrytania"),
	(1382, 84, "06", "Fthiotida"),
	(1383, 84, "07", "Fokida"),
	(1384, 84, "11", "Argolida"),
	(1385, 84, "12", "Arkadia"),
	(1386, 84, "13", "Achaïa"),
	(1387, 84, "14", "Ileia"),
	(1388, 84, "15", "Korinthia"),
	(1389, 84, "16", "Lakonia"),
	(1390, 84, "17", "Messinia"),
	(1391, 84, "21", "Zakynthos"),
	(1392, 84, "22", "Kerkyra"),
	(1393, 84, "23", "Kefallonia"),
	(1394, 84, "24", "Lefkada"),
	(1395, 84, "31", "Arta"),
	(1396, 84, "32", "Thesprotia"),
	(1397, 84, "33", "Ioannina"),
	(1398, 84, "34", "Preveza"),
	(1399, 84, "41", "Karditsa"),
	(1400, 84, "42", "Larisa"),
	(1401, 84, "43", "Magnisia"),
	(1402, 84, "44", "Trikala"),
	(1403, 84, "51", "Grevena"),
	(1404, 84, "52", "Drama"),
	(1405, 84, "53", "Imathia"),
	(1406, 84, "54", "Thessaloniki"),
	(1407, 84, "55", "Kavala"),
	(1408, 84, "56", "Kastoria"),
	(1409, 84, "57", "Kilkis"),
	(1410, 84, "58", "Kozani"),
	(1411, 84, "59", "Pella"),
	(1412, 84, "61", "Pieria"),
	(1413, 84, "62", "Serres"),
	(1414, 84, "63", "Florina"),
	(1415, 84, "64", "Chalkidiki"),
	(1416, 84, "69", "Agio Oros"),
	(1417, 84, "71", "Evros"),
	(1418, 84, "72", "Xanthi"),
	(1419, 84, "73", "Rodopi"),
	(1420, 84, "81", "Dodekanisos"),
	(1421, 84, "82", "Kyklades"),
	(1422, 84, "83", "Lesvos"),
	(1423, 84, "84", "Samos"),
	(1424, 84, "85", "Chios"),
	(1425, 84, "91", "Irakleio"),
	(1426, 84, "92", "Lasithi"),
	(1427, 84, "93", "Rethymno"),
	(1428, 84, "94", "Chania"),
	(1429, 84, "A", "Anatoliki Makedonia kai Thraki"),
	(1430, 84, "A1", "Attiki"),
	(1431, 84, "B", "Kentriki Makedonia"),
	(1432, 84, "C", "Dytiki Makedonia"),
	(1433, 84, "D", "Ipeiros"),
	(1434, 84, "E", "Thessalia"),
	(1435, 84, "F", "Ionia Nisia"),
	(1436, 84, "G", "Dytiki Ellada"),
	(1437, 84, "H", "Sterea Ellada"),
	(1438, 84, "I", "Attiki"),
	(1439, 84, "J", "Peloponnisos"),
	(1440, 84, "K", "Voreio Aigaio"),
	(1441, 84, "L", "Notio Aigaio"),
	(1442, 84, "M", "Kriti"),
	(1443, 85, "KU", "Kommune Kujalleq (kl)"),
	(1444, 85, "QA", "Qaasuitsup Kommunia (kl)"),
	(1445, 85, "QE", "Qeqqata Kommunia (kl)"),
	(1446, 85, "SM", "Kommuneqarfik Sermersooq (kl)"),
	(1447, 86, "01", "Saint Andrew"),
	(1448, 86, "02", "Saint David"),
	(1449, 86, "03", "Saint George"),
	(1450, 86, "04", "Saint John"),
	(1451, 86, "05", "Saint Mark"),
	(1452, 86, "06", "Saint Patrick"),
	(1453, 86, "10", "Southern Grenadine Islands"),
	(1454, 89, "AV", "Alta Verapaz"),
	(1455, 89, "BV", "Baja Verapaz"),
	(1456, 89, "CM", "Chimaltenango"),
	(1457, 89, "CQ", "Chiquimula"),
	(1458, 89, "ES", "Escuintla"),
	(1459, 89, "GU", "Guatemala"),
	(1460, 89, "HU", "Huehuetenango"),
	(1461, 89, "IZ", "Izabal"),
	(1462, 89, "JA", "Jalapa"),
	(1463, 89, "JU", "Jutiapa"),
	(1464, 89, "PE", "Petén"),
	(1465, 89, "PR", "El Progreso"),
	(1466, 89, "QC", "Quiché"),
	(1467, 89, "QZ", "Quetzaltenango"),
	(1468, 89, "RE", "Retalhuleu"),
	(1469, 89, "SA", "Sacatepéquez"),
	(1470, 89, "SM", "San Marcos"),
	(1471, 89, "SO", "Sololá"),
	(1472, 89, "SR", "Santa Rosa"),
	(1473, 89, "SU", "Suchitepéquez"),
	(1474, 89, "TO", "Totonicapán"),
	(1475, 89, "ZA", "Zacapa"),
	(1476, 90, "B", "Boké"),
	(1477, 90, "BE", "Beyla"),
	(1478, 90, "BF", "Boffa"),
	(1479, 90, "BK", "Boké"),
	(1480, 90, "C", "Conakry"),
	(1481, 90, "CO", "Coyah"),
	(1482, 90, "D", "Kindia"),
	(1483, 90, "DB", "Dabola"),
	(1484, 90, "DI", "Dinguiraye"),
	(1485, 90, "DL", "Dalaba"),
	(1486, 90, "DU", "Dubréka"),
	(1487, 90, "F", "faranah"),
	(1488, 90, "FA", "Faranah"),
	(1489, 90, "FO", "Forécariah"),
	(1490, 90, "FR", "Fria"),
	(1491, 90, "GA", "Gaoual"),
	(1492, 90, "GU", "Guékédou"),
	(1493, 90, "K", "Kankan"),
	(1494, 90, "KA", "Kankan"),
	(1495, 90, "KB", "Koubia"),
	(1496, 90, "KD", "Kindia"),
	(1497, 90, "KE", "Kérouané"),
	(1498, 90, "KN", "Koundara"),
	(1499, 90, "KO", "Kouroussa"),
	(1500, 90, "KS", "Kissidougou"),
	(1501, 90, "L", "Labé"),
	(1502, 90, "LA", "Labé"),
	(1503, 90, "LE", "Lélouma"),
	(1504, 90, "LO", "Lola"),
	(1505, 90, "M", "Mamou"),
	(1506, 90, "MC", "Macenta"),
	(1507, 90, "MD", "Mandiana"),
	(1508, 90, "ML", "Mali"),
	(1509, 90, "MM", "Mamou"),
	(1510, 90, "N", "Nzérékoré"),
	(1511, 90, "NZ", "Nzérékoré"),
	(1512, 90, "PI", "Pita"),
	(1513, 90, "SI", "Siguiri"),
	(1514, 90, "TE", "Télimélé"),
	(1515, 90, "TO", "Tougué"),
	(1516, 90, "YO", "Yomou"),
	(1517, 91, "BA", "Bafatá"),
	(1518, 91, "BL", "Bolama"),
	(1519, 91, "BM", "Biombo"),
	(1520, 91, "BS", "Bissau"),
	(1521, 91, "CA", "Cacheu"),
	(1522, 91, "GA", "Gabú"),
	(1523, 91, "L", "Leste"),
	(1524, 91, "N", "Norte"),
	(1525, 91, "OI", "Oio"),
	(1526, 91, "QU", "Quinara"),
	(1527, 91, "S", "Sul"),
	(1528, 91, "TO", "Tombali"),
	(1529, 92, "BA", "Barima-Waini"),
	(1530, 92, "CU", "Cuyuni-Mazaruni"),
	(1531, 92, "DE", "Demerara-Mahaica"),
	(1532, 92, "EB", "East Berbice-Corentyne"),
	(1533, 92, "ES", "Essequibo Islands-West Demerara"),
	(1534, 92, "MA", "Mahaica-Berbice"),
	(1535, 92, "PM", "Pomeroon-Supenaam"),
	(1536, 92, "PT", "Potaro-Siparuni"),
	(1537, 92, "UD", "Upper Demerara-Berbice"),
	(1538, 92, "UT", "Upper Takutu-Upper Essequibo"),
	(1539, 93, "AR", "Artibonite"),
	(1540, 93, "CE", "Centre"),
	(1541, 93, "GA", "Grande-Anse"),
	(1542, 93, "ND", "Nord"),
	(1543, 93, "NE", "Nord-Est"),
	(1544, 93, "NI", "Nippes"),
	(1545, 93, "NO", "Nord-Ouest"),
	(1546, 93, "OU", "Ouest"),
	(1547, 93, "SD", "Sud"),
	(1548, 93, "SE", "Sud-Est"),
	(1549, 95, "AT", "Atlántida"),
	(1550, 95, "CH", "Choluteca"),
	(1551, 95, "CL", "Colón"),
	(1552, 95, "CM", "Comayagua"),
	(1553, 95, "CP", "Copán"),
	(1554, 95, "CR", "Cortés"),
	(1555, 95, "EP", "El Paraíso"),
	(1556, 95, "FM", "Francisco Morazán"),
	(1557, 95, "GD", "Gracias a Dios"),
	(1558, 95, "IB", "Islas de la Bahía"),
	(1559, 95, "IN", "Intibucá"),
	(1560, 95, "LE", "Lempira"),
	(1561, 95, "LP", "La Paz"),
	(1562, 95, "OC", "Ocotepeque"),
	(1563, 95, "OL", "Olancho"),
	(1564, 95, "SB", "Santa Bárbara"),
	(1565, 95, "VA", "Valle"),
	(1566, 95, "YO", "Yoro"),
	(1567, 97, "BA", "Baranya"),
	(1568, 97, "BC", "Békéscsaba"),
	(1569, 97, "BE", "Békés"),
	(1570, 97, "BK", "Bács-Kiskun"),
	(1571, 97, "BU", "Budapest"),
	(1572, 97, "BZ", "Borsod-Abaúj-Zemplén"),
	(1573, 97, "CS", "Csongrád"),
	(1574, 97, "DE", "Debrecen"),
	(1575, 97, "DU", "Dunaújváros"),
	(1576, 97, "EG", "Eger"),
	(1577, 97, "ER", "Erd"),
	(1578, 97, "FE", "Fejér"),
	(1579, 97, "GS", "Gyor-Moson-Sopron"),
	(1580, 97, "GY", "Gyor"),
	(1581, 97, "HB", "Hajdú-Bihar"),
	(1582, 97, "HE", "Heves"),
	(1583, 97, "HV", "Hódmezovásárhely"),
	(1584, 97, "JN", "Jász-Nagykun-Szolnok"),
	(1585, 97, "KE", "Komárom-Esztergom"),
	(1586, 97, "KM", "Kecskemét"),
	(1587, 97, "KV", "Kaposvár"),
	(1588, 97, "MI", "Miskolc"),
	(1589, 97, "NK", "Nagykanizsa"),
	(1590, 97, "NO", "Nógrád"),
	(1591, 97, "NY", "Nyíregyháza"),
	(1592, 97, "PE", "Pest"),
	(1593, 97, "PS", "Pécs"),
	(1594, 97, "SD", "Szeged"),
	(1595, 97, "SF", "Székesfehérvár"),
	(1596, 97, "SH", "Szombathely"),
	(1597, 97, "SK", "Szolnok"),
	(1598, 97, "SN", "Sopron"),
	(1599, 97, "SO", "Somogy"),
	(1600, 97, "SS", "Szekszárd"),
	(1601, 97, "ST", "Salgótarján"),
	(1602, 97, "SZ", "Szabolcs-Szatmár-Bereg"),
	(1603, 97, "TB", "Tatabánya"),
	(1604, 97, "TO", "Tolna"),
	(1605, 97, "VA", "Vas"),
	(1606, 97, "VE", "Veszprém"),
	(1607, 97, "VM", "Veszprém City"),
	(1608, 97, "ZA", "Zala"),
	(1609, 97, "ZE", "Zalaegerszeg"),
	(1610, 98, "0", "Reykjavík"),
	(1611, 98, "1", "Höfuðborgarsvæði utan Reykjavíkur"),
	(1612, 98, "2", "Suðurnes"),
	(1613, 98, "3", "Vesturland"),
	(1614, 98, "4", "Vestfirðir"),
	(1615, 98, "5", "Norðurland vestra"),
	(1616, 98, "6", "Norðurland eystra"),
	(1617, 98, "7", "Austurland"),
	(1618, 98, "8", "Suðurland"),
	(1619, 99, "AN", "Andaman & Nicobar"),
	(1620, 99, "AP", "Andhra Pradesh"),
	(1621, 99, "AR", "Arunachal Pradesh"),
	(1622, 99, "AS", "Assam"),
	(1623, 99, "BR", "Bihar"),
	(1624, 99, "CA", "Chhatisgarh"),
	(1625, 99, "CT", "Chhattisgarh"),
	(1626, 99, "DD", "Daman and Diu"),
	(1627, 99, "DL", "Delhi"),
	(1628, 99, "DR", "Dadra & Nagar Haveli"),
	(1629, 99, "FSB", "Faisalabad"),
	(1630, 99, "GA", "Goa"),
	(1631, 99, "GJ", "Gujarat"),
	(1632, 99, "GUJ", "Gujrat"),
	(1633, 99, "HP", "Himachal Pradesh"),
	(1634, 99, "HR", "Haryana"),
	(1635, 99, "ISB", "Islamabad"),
	(1636, 99, "JH", "Jharkhand"),
	(1637, 99, "JK", "Jammu & Kashmir"),
	(1638, 99, "KA", "Karnataka"),
	(1639, 99, "KHI", "Karachi"),
	(1640, 99, "KL", "Kerala"),
	(1641, 99, "LD", "Lakshadweep"),
	(1642, 99, "LH", "Lahore"),
	(1643, 99, "MH", "Maharashtra"),
	(1644, 99, "ML", "Meghalaya"),
	(1645, 99, "MN", "Manipur"),
	(1646, 99, "MP", "Madhya Pradesh"),
	(1647, 99, "MZ", "Mizoram"),
	(1648, 99, "NL", "Nagaland"),
	(1649, 99, "OR", "Orrisa"),
	(1650, 99, "PB", "Punjab"),
	(1651, 99, "PSH", "Peshawar"),
	(1652, 99, "PY", "Pondicherry"),
	(1653, 99, "QUE", "Quetta"),
	(1654, 99, "RIP", "Rawal Pindi"),
	(1655, 99, "RJ", "Rajasthan"),
	(1656, 99, "SAH", "Sahiwal"),
	(1657, 99, "SK", "Sikkim"),
	(1658, 99, "TN", "Tamil Nadu"),
	(1659, 99, "TR", "Tripura"),
	(1660, 99, "UP", "Uttar Pradesh"),
	(1661, 99, "UT", "Uttaranchal"),
	(1662, 99, "WB", "West Bengal"),
	(1663, 100, "AC", "Special Region of Aceh"),
	(1664, 100, "BA", "Bali"),
	(1665, 100, "BB", "Bangka-Belitung"),
	(1666, 100, "BE", "Bengkulu"),
	(1667, 100, "BT", "Banten"),
	(1668, 100, "GO", "Gorontalo"),
	(1669, 100, "JA", "Jambi"),
	(1670, 100, "JB", "West Java"),
	(1671, 100, "JI", "East Java"),
	(1672, 100, "JK", "Jakarta (Special City District)"),
	(1673, 100, "JT", "Central Java"),
	(1674, 100, "KB", "West Kalimantan"),
	(1675, 100, "KI", "East Kalimantan[4]"),
	(1676, 100, "KR", "Riau Islands"),
	(1677, 100, "KS", "South Kalimantan"),
	(1678, 100, "KT", "Central Kalimantan"),
	(1679, 100, "KU", "North Kalimantan"),
	(1680, 100, "LA", "Lampung"),
	(1681, 100, "MA", "Maluku"),
	(1682, 100, "MU", "North Maluku"),
	(1683, 100, "NB", "West Nusa Tenggara"),
	(1684, 100, "NT", "East Nusa Tenggara"),
	(1685, 100, "PA", "Special Region of Papua"),
	(1686, 100, "PB", "Special Region of West Papua"),
	(1687, 100, "RI", "Riau"),
	(1688, 100, "SA", "North Sulawesi"),
	(1689, 100, "SB", "West Sumatra"),
	(1690, 100, "SG", "Southeast Sulawesi"),
	(1691, 100, "SN", "South Sulawesi"),
	(1692, 100, "SR", "West Sulawesi"),
	(1693, 100, "SS", "South Sumatra"),
	(1694, 100, "ST", "Central Sulawesi"),
	(1695, 100, "SU", "North Sumatra"),
	(1696, 100, "YO", "Special Region of Yogyakarta"),
	(1697, 101, "01", "Az¯arbayjan-e Sharqi"),
	(1698, 101, "02", "Az¯arbayjan-e Gharbi"),
	(1699, 101, "03", "Ardabil"),
	(1700, 101, "04", "Esfahan"),
	(1701, 101, "05", "Ilam"),
	(1702, 101, "06", "Bushehr"),
	(1703, 101, "07", "Tehran"),
	(1704, 101, "08", "Chahar Mah¸all va Bakhtiari"),
	(1705, 101, "09", "Khorasan"),
	(1706, 101, "10", "Khuzestan"),
	(1707, 101, "11", "Zanjan"),
	(1708, 101, "12", "Semnan"),
	(1709, 101, "13", "Sistan va Baluchestan"),
	(1710, 101, "14", "Fars"),
	(1711, 101, "15", "Kerman"),
	(1712, 101, "16", "Kordestan"),
	(1713, 101, "17", "Kermanshah"),
	(1714, 101, "18", "Kohkiluyeh va Buyer Ahmad"),
	(1715, 101, "19", "Gilan"),
	(1716, 101, "20", "Lorestan"),
	(1717, 101, "21", "Mazandaran"),
	(1718, 101, "22", "Markazi"),
	(1719, 101, "23", "Hormozgan"),
	(1720, 101, "24", "Hamadan"),
	(1721, 101, "25", "Yazd"),
	(1722, 101, "26", "Qom"),
	(1723, 101, "27", "Golestan"),
	(1724, 101, "28", "Qazvin"),
	(1725, 101, "29", "Khorasan-e Janubi"),
	(1726, 101, "30", "Khorasan-e Razavi"),
	(1727, 101, "31", "Khorasan-e Shemali"),
	(1728, 102, "AN", "Al Anbar"),
	(1729, 102, "AR", "Arbil"),
	(1730, 102, "BA", "Al Basrah"),
	(1731, 102, "BB", "Babil"),
	(1732, 102, "BG", "Baghdad"),
	(1733, 102, "DA", "Dahuk"),
	(1734, 102, "DI", "Diyalá"),
	(1735, 102, "DQ", "Dhi Qar"),
	(1736, 102, "KA", "Karbala'"),
	(1737, 102, "MA", "Maysan"),
	(1738, 102, "MU", "Al Muthanná"),
	(1739, 102, "NA", "An Najaf"),
	(1740, 102, "NI", "Ninawá"),
	(1741, 102, "QA", "Al Qadisiyah"),
	(1742, 102, "SD", "Salah ad Din"),
	(1743, 102, "SU", "As Sulaymaniyah"),
	(1744, 102, "TS", "At Ta'mim"),
	(1745, 102, "WA", "Wasit"),
	(1746, 103, "C", "Connaught "),
	(1747, 103, "CE", "Clare"),
	(1748, 103, "CN", "Cavan"),
	(1749, 103, "CO", "Cork"),
	(1750, 103, "CW", "Carlow"),
	(1751, 103, "D", "Dublin"),
	(1752, 103, "DL", "Donegal"),
	(1753, 103, "G", "Galway"),
	(1754, 103, "KE", "Kildare"),
	(1755, 103, "KK", "Kilkenny"),
	(1756, 103, "KY", "Kerry"),
	(1757, 103, "L", "Leinster "),
	(1758, 103, "LD", "Longford"),
	(1759, 103, "LH", "Louth"),
	(1760, 103, "LK", "Limerick"),
	(1761, 103, "LM", "Leitrim"),
	(1762, 103, "LS", "Laois"),
	(1763, 103, "M", "Munster "),
	(1764, 103, "MH", "Meath"),
	(1765, 103, "MN", "Monaghan"),
	(1766, 103, "MO", "Mayo"),
	(1767, 103, "OY", "Offaly"),
	(1768, 103, "RN", "Roscommon"),
	(1769, 103, "SO", "Sligo"),
	(1770, 103, "TA", "Tipperary"),
	(1771, 103, "U", "Ulster "),
	(1772, 103, "WD", "Waterford"),
	(1773, 103, "WH", "Westmeath"),
	(1774, 103, "WW", "Wicklow"),
	(1775, 103, "WX", "Wexford"),
	(1776, 104, "D", "HaDarom"),
	(1777, 104, "HA", "Haifa"),
	(1778, 104, "JM", "Yerushalayim"),
	(1779, 104, "M", "HaMerkaz"),
	(1780, 104, "TA", "Tel-Aviv"),
	(1781, 104, "Z", "HaZafon"),
	(1782, 105, "AG", "Agrigento"),
	(1783, 105, "AL", "Alessandria"),
	(1784, 105, "AN", "Ancona"),
	(1785, 105, "AO", "Aosta"),
	(1786, 105, "AP", "Ascoli Piceno"),
	(1787, 105, "AQ", "L'Aquila"),
	(1788, 105, "AR", "Arezzo"),
	(1789, 105, "AT", "Asti"),
	(1790, 105, "AV", "Avellino"),
	(1791, 105, "BA", "Bari"),
	(1792, 105, "BG", "Bergamo"),
	(1793, 105, "BI", "Biella"),
	(1794, 105, "BL", "Belluno"),
	(1795, 105, "BN", "Benevento"),
	(1796, 105, "BO", "Bologna"),
	(1797, 105, "BR", "Brindisi"),
	(1798, 105, "BS", "Brescia"),
	(1799, 105, "BZ", "Bolzano"),
	(1800, 105, "CA", "Cagliari"),
	(1801, 105, "CB", "Campobasso"),
	(1802, 105, "CE", "Caserta"),
	(1803, 105, "CH", "Chieti"),
	(1804, 105, "CL", "Caltanissetta"),
	(1805, 105, "CN", "Cuneo"),
	(1806, 105, "CO", "Como"),
	(1807, 105, "CR", "Cremona"),
	(1808, 105, "CS", "Cosenza"),
	(1809, 105, "CT", "Catania"),
	(1810, 105, "CZ", "Catanzaro"),
	(1811, 105, "EN", "Enna"),
	(1812, 105, "FE", "Ferrara"),
	(1813, 105, "FG", "Foggia"),
	(1814, 105, "FI", "Firenze"),
	(1815, 105, "FO", "Forlì"),
	(1816, 105, "FR", "Frosinone "),
	(1817, 105, "GE", "Genova"),
	(1818, 105, "GO", "Gorizia"),
	(1819, 105, "GR", "Grosseto"),
	(1820, 105, "IM", "Imperia"),
	(1821, 105, "IS", "Isernia"),
	(1822, 105, "KR", "Crotone"),
	(1823, 105, "LC", "Lecco"),
	(1824, 105, "LE", "Lecce"),
	(1825, 105, "LI", "Livorno"),
	(1826, 105, "LO", "Lodi"),
	(1827, 105, "LT", "Latina"),
	(1828, 105, "LU", "Lucca"),
	(1829, 105, "MC", "Macerata"),
	(1830, 105, "ME", "Messina"),
	(1831, 105, "MI", "Milano"),
	(1832, 105, "MN", "Mantova"),
	(1833, 105, "MO", "Modena"),
	(1834, 105, "MS", "Massa-Carrara"),
	(1835, 105, "MT", "Matera"),
	(1836, 105, "NA", "Napoli"),
	(1837, 105, "NO", "Novara"),
	(1838, 105, "NU", "Nuoro"),
	(1839, 105, "OR", "Oristano"),
	(1840, 105, "PA", "Palermo"),
	(1841, 105, "PC", "Piacenza"),
	(1842, 105, "PD", "Padova"),
	(1843, 105, "PE", "Pescara"),
	(1844, 105, "PG", "Perugia"),
	(1845, 105, "PI", "Pisa"),
	(1846, 105, "PN", "Pordenone"),
	(1847, 105, "PO", "Prato"),
	(1848, 105, "PR", "Parma"),
	(1849, 105, "PS", "Pesaro e Urbino"),
	(1850, 105, "PT", "Pistoia"),
	(1851, 105, "PV", "Pavia"),
	(1852, 105, "PZ", "Potenza"),
	(1853, 105, "RA", "Ravenna"),
	(1854, 105, "RC", "Reggio Calabria"),
	(1855, 105, "RE", "Reggio Emilia"),
	(1856, 105, "RG", "Ragusa"),
	(1857, 105, "RI", "Rieti"),
	(1858, 105, "RM", "Roma"),
	(1859, 105, "RN", "Rimini"),
	(1860, 105, "RO", "Rovigo"),
	(1861, 105, "SA", "Salerno"),
	(1862, 105, "SI", "Siena"),
	(1863, 105, "SO", "Sondrio"),
	(1864, 105, "SP", "La Spezia"),
	(1865, 105, "SR", "Siracusa"),
	(1866, 105, "SS", "Sassari"),
	(1867, 105, "SV", "Savona"),
	(1868, 105, "TA", "Taranto"),
	(1869, 105, "TE", "Teramo"),
	(1870, 105, "TN", "Trento"),
	(1871, 105, "TO", "Torino"),
	(1872, 105, "TP", "Trapani"),
	(1873, 105, "TR", "Terni"),
	(1874, 105, "TS", "Trieste"),
	(1875, 105, "TV", "Treviso"),
	(1876, 105, "UD", "Udine"),
	(1877, 105, "VA", "Varese"),
	(1878, 105, "VB", "Verbano-Cusio-Ossola"),
	(1879, 105, "VC", "Vercelli"),
	(1880, 105, "VE", "Venezia"),
	(1881, 105, "VI", "Vicenza"),
	(1882, 105, "VR", "Verona"),
	(1883, 105, "VT", "Viterbo"),
	(1884, 105, "VV", "Vibo Valentia"),
	(1885, 106, "01", "Kingston"),
	(1886, 106, "02", "Saint Andrew"),
	(1887, 106, "03", "Saint Thomas"),
	(1888, 106, "04", "Portland"),
	(1889, 106, "05", "Saint Mary"),
	(1890, 106, "06", "Saint Ann"),
	(1891, 106, "07", "Trelawny"),
	(1892, 106, "08", "Saint James"),
	(1893, 106, "09", "Hanover"),
	(1894, 106, "10", "Westmoreland"),
	(1895, 106, "11", "Saint Elizabeth"),
	(1896, 106, "12", "Manchester"),
	(1897, 106, "13", "Clarendon"),
	(1898, 106, "14", "Saint Catherine"),
	(1899, 107, "01", "Hokkaido"),
	(1900, 107, "02", "Aomori"),
	(1901, 107, "03", "Iwate"),
	(1902, 107, "04", "Miyagi"),
	(1903, 107, "05", "Akita"),
	(1904, 107, "06", "Yamagata"),
	(1905, 107, "07", "Fukushima"),
	(1906, 107, "08", "Ibaraki"),
	(1907, 107, "09", "Tochigi"),
	(1908, 107, "10", "Gunma"),
	(1909, 107, "11", "Saitama"),
	(1910, 107, "12", "Chiba"),
	(1911, 107, "13", "Tokio"),
	(1912, 107, "14", "Kanagawa"),
	(1913, 107, "15", "Niigata"),
	(1914, 107, "16", "Toyama"),
	(1915, 107, "17", "Ishikawa"),
	(1916, 107, "18", "Fukui"),
	(1917, 107, "19", "Yamanashi"),
	(1918, 107, "20", "Nagano"),
	(1919, 107, "21", "Gifu"),
	(1920, 107, "22", "Shizuoka"),
	(1921, 107, "23", "Aichi"),
	(1922, 107, "24", "Mie"),
	(1923, 107, "25", "Shiga"),
	(1924, 107, "26", "Kyoto"),
	(1925, 107, "27", "Osaka"),
	(1926, 107, "28", "Hyogo"),
	(1927, 107, "29", "Nara"),
	(1928, 107, "30", "Wakayama"),
	(1929, 107, "31", "Tottori"),
	(1930, 107, "32", "Shimane"),
	(1931, 107, "33", "Okayama"),
	(1932, 107, "34", "Hiroshima"),
	(1933, 107, "35", "Yamaguchi"),
	(1934, 107, "36", "Tokushima"),
	(1935, 107, "37", "Kagawa"),
	(1936, 107, "38", "Ehime"),
	(1937, 107, "39", "Kochi"),
	(1938, 107, "40", "Fukuoka"),
	(1939, 107, "41", "Saga"),
	(1940, 107, "42", "Nagasaki"),
	(1941, 107, "43", "Kumamoto"),
	(1942, 107, "44", "Oita"),
	(1943, 107, "45", "Miyazaki"),
	(1944, 107, "46", "Kagoshima"),
	(1945, 107, "47", "Okinawa"),
	(1946, 108, "AJ", "‘Ajlūn"),
	(1947, 108, "AM", "‘Ammān (Al ‘A̅ şimah)"),
	(1948, 108, "AQ", "Al ‘Aqabah"),
	(1949, 108, "AT", "At Tafilah"),
	(1950, 108, "AZ", "Az Zarqā'"),
	(1951, 108, "BA", "Al Balqa'"),
	(1952, 108, "IR", "Irbid"),
	(1953, 108, "JA", "Jarash"),
	(1954, 108, "KA", "Al Karak"),
	(1955, 108, "MA", "Al Mafraq"),
	(1956, 108, "MD", "Mādabā"),
	(1957, 108, "MN", "Ma`an"),
	(1958, 109, "AKM", "Aqmola oblysy"),
	(1959, 109, "AKT", "Aqtöbe oblysy"),
	(1960, 109, "ALA", "Almaty"),
	(1961, 109, "ALM", "Almaty oblysy"),
	(1962, 109, "AST", "Astana"),
	(1963, 109, "ATY", "Atyrau oblysy"),
	(1964, 109, "BAY", "Bayqongyr"),
	(1965, 109, "KAR", "Qaraghandy oblysy"),
	(1966, 109, "KUS", "Qostanay oblysy"),
	(1967, 109, "KZY", "Qyzylorda oblysy"),
	(1968, 109, "MAN", "Mangghystau oblysy"),
	(1969, 109, "PAV", "Pavlodar oblysy"),
	(1970, 109, "SEV", "Soltüstik Qazaqstan oblysy"),
	(1971, 109, "VOS", "Shyghys Qazaqstan oblysy"),
	(1972, 109, "YUZ", "Ongtüstik Qazaqstan oblysy"),
	(1973, 109, "ZAP", "Batys Qazaqstan oblysy"),
	(1974, 109, "ZHA", "Zhambyl oblysy"),
	(1975, 110, "110", "Nairobi"),
	(1976, 110, "200", "Central"),
	(1977, 110, "300", "Coast"),
	(1978, 110, "400", "Eastern"),
	(1979, 110, "500", "North-Eastern"),
	(1980, 110, "600", "Nyanza"),
	(1981, 110, "700", "Rift Valley"),
	(1982, 110, "800", "Western"),
	(1983, 111, "G", "Gilbert Islands"),
	(1984, 111, "L", "Line Islands"),
	(1985, 111, "P", "Phoenix Islands"),
	(1986, 112, "01", "Pyongyang"),
	(1987, 112, "02", "Pyongan-namdo"),
	(1988, 112, "03", "Pyongan-bukdo"),
	(1989, 112, "04", "Chagang-do"),
	(1990, 112, "05", "Hwanghae-namdo"),
	(1991, 112, "06", "Hwanghae-bukto"),
	(1992, 112, "07", "Kangwon-do"),
	(1993, 112, "08", "Hamgyong-namdo"),
	(1994, 112, "09", "Hamgyong-bukdo"),
	(1995, 112, "10", "Yanggang-do"),
	(1996, 112, "13", "Nason"),
	(1997, 113, "11", "Seoul Teugbyeolsi [Seoul-T'ukpyolshi]"),
	(1998, 113, "26", "Busan Gwang'yeogsi [Pusan-Kwangyokshi]"),
	(1999, 113, "27", "Daegu Gwang'yeogsi [Taegu-Kwangyokshi]"),
	(2000, 113, "28", "Incheon Gwang'yeogsi [Inch'n-Kwangyokshi]"),
	(2001, 113, "29", "Gwangju Gwang'yeogsi [Kwangju-Kwangyokshi]"),
	(2002, 113, "30", "Daejeon Gwang'yeogsi [Taejon-Kwangyokshi]"),
	(2003, 113, "31", "Ulsan Gwang'yeogsi [Ulsan-Kwangyokshi]"),
	(2004, 113, "41", "Gyeonggido [Kyonggi-do]"),
	(2005, 113, "42", "Gang'weondo [Kang-won-do]"),
	(2006, 113, "43", "Chungcheongbugdo [Ch'ungch'ongbuk-do]"),
	(2007, 113, "44", "Chungcheongnamdo [Ch'ungch'ongnam-do]"),
	(2008, 113, "45", "Jeonrabugdo[Chollabuk-do]"),
	(2009, 113, "46", "Jeonranamdo [Chollanam-do]"),
	(2010, 113, "47", "Gyeongsangbugdo [Kyongsangbuk-do]"),
	(2011, 113, "48", "Gyeongsangnamdo [Kyongsangnam-do]"),
	(2012, 113, "49", "Jejudo [Cheju-do]"),
	(2013, 114, "AH", "Al Ahmadi"),
	(2014, 114, "FA", "Al Farwaniyah"),
	(2015, 114, "HA", "Hawalli"),
	(2016, 114, "JA", "Al Jahrah"),
	(2017, 114, "KU", "Al Kuwayt (Al ‘Āşimah)"),
	(2018, 114, "MU", "Mubarak al-Kabir"),
	(2019, 115, "B", "Batken"),
	(2020, 115, "C", "Chü"),
	(2021, 115, "GB", "Bishkek"),
	(2022, 115, "J", "Jalal-Abad"),
	(2023, 115, "N", "Naryn"),
	(2024, 115, "O", "Osh"),
	(2025, 115, "T", "Talas"),
	(2026, 115, "Y", "Ysyk-Köl"),
	(2027, 116, "AT", "Attapu [Attopeu]"),
	(2028, 116, "BK", "Bokèo"),
	(2029, 116, "BL", "Bolikhamxai [Borikhane]"),
	(2030, 116, "CH", "Champasak [Champassak]"),
	(2031, 116, "HO", "Houaphan"),
	(2032, 116, "KH", "Khammouan"),
	(2033, 116, "LM", "Louang Namtha"),
	(2034, 116, "LP", "Louangphabang [Louang Prabang]"),
	(2035, 116, "OU", "Oudômxai [Oudomsai]"),
	(2036, 116, "PH", "Phôngsali [Phong Saly]"),
	(2037, 116, "SL", "Salavan [Saravane]"),
	(2038, 116, "SV", "Savannakhét"),
	(2039, 116, "VI", "Vientiane"),
	(2040, 116, "VT", "Vientiane Prefecture"),
	(2041, 116, "XA", "Xaignabouli [Sayaboury]"),
	(2042, 116, "XE", "Xékong [Sékong]"),
	(2043, 116, "XI", "Xiangkhoang [Xieng Khouang]"),
	(2044, 116, "XN", "Xaisômboun"),
	(2045, 117, "001", "Aglonas novads (Aglona)"),
	(2046, 117, "002", "Aizkraukles novads (Aizkraukle)"),
	(2047, 117, "003", "Aizputes novads (Aizpute)"),
	(2048, 117, "004", "Aknīstes novads (Aknīste)"),
	(2049, 117, "005", "Alojas novads (Aloja)"),
	(2050, 117, "006", "Alsungas novads (Alsunga)"),
	(2051, 117, "007", "Alūksnes novads (Alūksne)"),
	(2052, 117, "008", "Amatas novads (Amata)"),
	(2053, 117, "009", "Apes novads (Ape)"),
	(2054, 117, "010", "Auces novads (Auce)"),
	(2055, 117, "011", "Ādažu novads (Ādaži)"),
	(2056, 117, "012", "Babītes novads (Babīte)"),
	(2057, 117, "013", "Baldones novads (Baldone)"),
	(2058, 117, "014", "Baltinavas novads (Baltinava)"),
	(2059, 117, "015", "Balvu novads (Balvi)"),
	(2060, 117, "016", "Bauskas novads (Bauska)"),
	(2061, 117, "017", "Beverīnas novads (Beverīna)"),
	(2062, 117, "018", "Brocēnu novads (Brocēni)"),
	(2063, 117, "019", "Burtnieku novads (Burtnieki)"),
	(2064, 117, "020", "Carnikavas novads (Carnikava)"),
	(2065, 117, "021", "Cesvaines novads (Cesvaine)"),
	(2066, 117, "022", "Cēsu novads (Cēsis)"),
	(2067, 117, "023", "Ciblas novads (Cibla)"),
	(2068, 117, "024", "Dagdas novads (Dagda)"),
	(2069, 117, "025", "Daugavpils novads (Daugavpils)"),
	(2070, 117, "026", "Dobeles novads (Dobele)"),
	(2071, 117, "027", "Dundagas novads (Dundaga)"),
	(2072, 117, "028", "Durbes novads (Durbe)"),
	(2073, 117, "029", "Engures novads (Engure)"),
	(2074, 117, "030", "Ērgļu novads (Ērgļi)"),
	(2075, 117, "031", "Garkalnes novads (Garkalne)"),
	(2076, 117, "032", "Grobiņas novads (Grobiņa)"),
	(2077, 117, "033", "Gulbenes novads (Gulbene)"),
	(2078, 117, "034", "Iecavas novads (Iecava)"),
	(2079, 117, "035", "Ikšķiles novads (Ikšķile)"),
	(2080, 117, "036", "Ilūkstes novads (Ilūkste)"),
	(2081, 117, "037", "Inčukalna novads (Inčukalns)"),
	(2082, 117, "038", "Jaunjelgavas novads (Jaunjelgava)"),
	(2083, 117, "039", "Jaunpiebalgas novads (Jaunpiebalga)"),
	(2084, 117, "040", "Jaunpils novads (Jaunpils)"),
	(2085, 117, "041", "Jelgavas novads (Jelgava)"),
	(2086, 117, "042", "Jēkabpils novads (Jēkabpils)"),
	(2087, 117, "043", "Kandavas novads (Kandava)"),
	(2088, 117, "044", "Kārsavas novads (Kārsava)"),
	(2089, 117, "045", "Kocēnu novads"),
	(2090, 117, "046", "Kokneses novads (Koknese)"),
	(2091, 117, "047", "Krāslavas novads (Krāslava)"),
	(2092, 117, "048", "Krimuldas novads (Krimulda)"),
	(2093, 117, "049", "Krustpils novads (Krustpils)"),
	(2094, 117, "050", "Kuldīgas novads (Kuldīga)"),
	(2095, 117, "051", "Ķeguma novads (Ķegums)"),
	(2096, 117, "052", "Ķekavas novads (Ķekava)"),
	(2097, 117, "053", "Lielvārdes novads (Lielvārde)"),
	(2098, 117, "054", "Limbažu novads (Limbaži)"),
	(2099, 117, "055", "Līgatnes novads (Līgatne)"),
	(2100, 117, "056", "Līvānu novads (Līvāni)"),
	(2101, 117, "057", "Lubānas novads (Lubāna)"),
	(2102, 117, "058", "Ludzas novads (Ludza)"),
	(2103, 117, "059", "Madonas novads (Madona)"),
	(2104, 117, "060", "Mazsalacas novads (Mazsalaca)"),
	(2105, 117, "061", "Mālpils novads (Mālpils)"),
	(2106, 117, "062", "Mārupes novads (Mārupe)"),
	(2107, 117, "063", "Mērsraga novads"),
	(2108, 117, "064", "Naukšēnu novads (Naukšēni)"),
	(2109, 117, "065", "Neretas novads (Nereta)"),
	(2110, 117, "066", "Nīcas novads (Nīca)"),
	(2111, 117, "067", "Ogres novads (Ogre)"),
	(2112, 117, "068", "Olaines novads (Olaine)"),
	(2113, 117, "069", "Ozolnieku novads (Ozolnieki)"),
	(2114, 117, "070", "Pārgaujas novads (Pārgauja)"),
	(2115, 117, "071", "Pāvilostas novads (Pāvilosta)"),
	(2116, 117, "072", "Pļaviņu novads (Pļaviņas)"),
	(2117, 117, "073", "Preiļu novads (Preiļi)"),
	(2118, 117, "074", "Priekules novads (Priekule)"),
	(2119, 117, "075", "Priekuļu novads (Priekuļi)"),
	(2120, 117, "076", "Raunas novads (Rauna)"),
	(2121, 117, "077", "Rēzeknes novads (Rēzekne)"),
	(2122, 117, "078", "Riebiņu novads (Riebiņi)"),
	(2123, 117, "079", "Rojas novads (Roja)"),
	(2124, 117, "080", "Ropažu novads (Ropaži)"),
	(2125, 117, "081", "Rucavas novads (Rucava)"),
	(2126, 117, "082", "Rugāju novads (Rugāji)"),
	(2127, 117, "083", "Rundāles novads (Rundāle)"),
	(2128, 117, "084", "Rūjienas novads (Rūjiena)"),
	(2129, 117, "085", "Salas novads (Sala)"),
	(2130, 117, "086", "Salacgrīvas novads (Salacgrīva)"),
	(2131, 117, "087", "Salaspils novads (Salaspils)"),
	(2132, 117, "088", "Saldus novads (Saldus)"),
	(2133, 117, "089", "Saulkrastu novads (Saulkrasti)"),
	(2134, 117, "090", "Sējas novads (Sēja)"),
	(2135, 117, "091", "Siguldas novads (Sigulda)"),
	(2136, 117, "092", "Skrīveru novads (Skrīveri)"),
	(2137, 117, "093", "Skrundas novads (Skrunda)"),
	(2138, 117, "094", "Smiltenes novads (Smiltene)"),
	(2139, 117, "095", "Stopiņu novads (Stopiņi)"),
	(2140, 117, "096", "Strenču novads (Strenči)"),
	(2141, 117, "097", "Talsu novads (Talsi)"),
	(2142, 117, "098", "Tērvetes novads (Tērvete)"),
	(2143, 117, "099", "Tukuma novads (Tukums)"),
	(2144, 117, "100", "Vaiņodes novads (Vaiņode)"),
	(2145, 117, "101", "Valkas novads (Valka)"),
	(2146, 117, "102", "Varakļānu novads (Varakļāni)"),
	(2147, 117, "103", "Vārkavas novads (Vārkava)"),
	(2148, 117, "104", "Vecpiebalgas novads (Vecpiebalga)"),
	(2149, 117, "105", "Vecumnieku novads (Vecumnieki)"),
	(2150, 117, "106", "Ventspils novads (Ventspils)"),
	(2151, 117, "107", "Viesītes novads (Viesīte)"),
	(2152, 117, "108", "Viļakas novads (Viļaka)"),
	(2153, 117, "109", "Viļānu novads (Viļāni)"),
	(2154, 117, "110", "Zilupes novads (Zilupe)"),
	(2155, 117, "DGV", "Daugavpils"),
	(2156, 117, "JEL", "Jelgava"),
	(2157, 117, "JKB", "Jēkabpils"),
	(2158, 117, "JUR", "Jurmala"),
	(2159, 117, "LPX", "Liepaja"),
	(2160, 117, "REZ", "Rezekne"),
	(2161, 117, "RIX", "Riga"),
	(2162, 117, "VEN", "Ventspils"),
	(2163, 117, "VMR", "Valmiera"),
	(2164, 118, "AK", "Aakkar"),
	(2165, 118, "AS", "Loubnâne ech Chemâli"),
	(2166, 118, "BA", "Beirut"),
	(2167, 118, "BH", "Baalbek-Hermel"),
	(2168, 118, "BI", "El Béqaa"),
	(2169, 118, "JA", "Loubnâne ej Jnoûbi"),
	(2170, 118, "JL", "Jabal Loubnâne"),
	(2171, 118, "NA", "Nabatîyé"),
	(2172, 119, "A", "Maseru"),
	(2173, 119, "B", "Butha-Buthe"),
	(2174, 119, "C", "Leribe"),
	(2175, 119, "D", "Berea"),
	(2176, 119, "E", "Mafeteng"),
	(2177, 119, "F", "Mohale's Hoek"),
	(2178, 119, "G", "Quthing"),
	(2179, 119, "H", "Qacha's Nek"),
	(2180, 119, "J", "Mokhotlong"),
	(2181, 119, "K", "Thaba-Tseka"),
	(2182, 120, "BG", "Bong"),
	(2183, 120, "BM", "Bomi"),
	(2184, 120, "CM", "Grand Cape Mount"),
	(2185, 120, "GB", "Grand Bassa"),
	(2186, 120, "GG", "Grand Gedeh"),
	(2187, 120, "GK", "Grand Kru"),
	(2188, 120, "LO", "Lofa"),
	(2189, 120, "MG", "Margibi"),
	(2190, 120, "MO", "Montserrado"),
	(2191, 120, "MY", "Maryland"),
	(2192, 120, "NI", "Nimba"),
	(2193, 120, "RI", "Rivercess"),
	(2194, 120, "SI", "Sinoe"),
	(2195, 120, "X1~", "Gbarpolu"),
	(2196, 120, "X2~", "River Gee"),
	(2197, 121, "BA", "Banghazi"),
	(2198, 121, "BU", "Al Butnan"),
	(2199, 121, "DR", "Darnah"),
	(2200, 121, "GT", "Ghat"),
	(2201, 121, "JA", "Al Jabal al Akhḑar"),
	(2202, 121, "JG", "Al Jabal al Gharbī"),
	(2203, 121, "JI", "Al Jifarah"),
	(2204, 121, "JU", "Al Jufrah"),
	(2205, 121, "KF", "Al Kufrah"),
	(2206, 121, "MB", "Al Marqab"),
	(2207, 121, "MI", "Misratah"),
	(2208, 121, "MJ", "Al Marj"),
	(2209, 121, "MQ", "Murzuq"),
	(2210, 121, "NL", "Nalut"),
	(2211, 121, "NQ", "An Nuqat al Khams"),
	(2212, 121, "SB", "Sabha"),
	(2213, 121, "SR", "Surt"),
	(2214, 121, "TB", "Tarabulus"),
	(2215, 121, "WA", "Al Wāḩāt"),
	(2216, 121, "WD", "Wādī al Ḩayāt"),
	(2217, 121, "WS", "Wādī ash Shāţiʾ"),
	(2218, 121, "ZA", "Az Zawiyah"),
	(2219, 122, "01", "Balzers"),
	(2220, 122, "02", "Eschen"),
	(2221, 122, "03", "Gamprin"),
	(2222, 122, "04", "Mauren"),
	(2223, 122, "05", "Planken"),
	(2224, 122, "06", "Ruggell"),
	(2225, 122, "07", "Schaan"),
	(2226, 122, "08", "Schellenberg"),
	(2227, 122, "09", "Triesen"),
	(2228, 122, "10", "Triesenberg"),
	(2229, 122, "11", "Vaduz"),
	(2230, 123, "AL", "Alytaus Apskritis"),
	(2231, 123, "KL", "Klaipedos Apskritis"),
	(2232, 123, "KU", "Kauno Apskritis"),
	(2233, 123, "MR", "Marijampoles Apskritis"),
	(2234, 123, "PN", "Panevežio Apskritis"),
	(2235, 123, "SA", "Šiauliu Apskritis"),
	(2236, 123, "TA", "Taurages Apskritis"),
	(2237, 123, "TE", "Telšiu Apskritis"),
	(2238, 123, "UT", "Utenos Apskritis"),
	(2239, 123, "VL", "Vilniaus Apskritis"),
	(2240, 124, "DI", "Diekirch"),
	(2241, 124, "GR", "Grevenmacher"),
	(2242, 124, "LU", "Luxemburg"),
	(2243, 125, "I", "Ilhas"),
	(2244, 125, "M", "Macau"),
	(2245, 126, "01", "Aerodrom"),
	(2246, 126, "02", "Aračinovo"),
	(2247, 126, "03", "Berovo"),
	(2248, 126, "04", "Bitola"),
	(2249, 126, "05", "Bogdanci"),
	(2250, 126, "06", "Bogovinje"),
	(2251, 126, "07", "Bosilovo"),
	(2252, 126, "08", "Brvenica"),
	(2253, 126, "09", "Butel"),
	(2254, 126, "10", "Valandovo"),
	(2255, 126, "11", "Vasilevo"),
	(2256, 126, "12", "Vevčani"),
	(2257, 126, "13", "Veles"),
	(2258, 126, "14", "Vinica"),
	(2259, 126, "15", "Vraneštica"),
	(2260, 126, "16", "Vrapčište"),
	(2261, 126, "17", "Gazi Baba"),
	(2262, 126, "18", "Gevgelija"),
	(2263, 126, "19", "Gostivar"),
	(2264, 126, "20", "Gradsko"),
	(2265, 126, "21", "Debar"),
	(2266, 126, "22", "Debarca"),
	(2267, 126, "23", "Delčevo"),
	(2268, 126, "24", "Demir Kapija"),
	(2269, 126, "25", "Demir Hisar"),
	(2270, 126, "26", "Dojran"),
	(2271, 126, "27", "Dolneni"),
	(2272, 126, "28", "Drugovo"),
	(2273, 126, "29", "Gjorče Petrov"),
	(2274, 126, "30", "Želino"),
	(2275, 126, "31", "Zajas"),
	(2276, 126, "32", "Zelenikovo"),
	(2277, 126, "33", "Zrnovci"),
	(2278, 126, "34", "Ilinden"),
	(2279, 126, "35", "Jegunovce"),
	(2280, 126, "36", "Kavadarci"),
	(2281, 126, "37", "Karbinci"),
	(2282, 126, "38", "Karpoš"),
	(2283, 126, "39", "Kisela Voda"),
	(2284, 126, "40", "Kičevo"),
	(2285, 126, "41", "Konče"),
	(2286, 126, "42", "Kočani"),
	(2287, 126, "43", "Kratovo"),
	(2288, 126, "44", "Kriva Palanka"),
	(2289, 126, "45", "Krivogaštani"),
	(2290, 126, "46", "Kruševo"),
	(2291, 126, "47", "Kumanovo"),
	(2292, 126, "48", "Lipkovo"),
	(2293, 126, "49", "Lozovo"),
	(2294, 126, "50", "Mavrovo i Rostuša"),
	(2295, 126, "51", "Makedonska Kamenica"),
	(2296, 126, "52", "Makedonski Brod"),
	(2297, 126, "53", "Mogila"),
	(2298, 126, "54", "Negotino"),
	(2299, 126, "55", "Novaci"),
	(2300, 126, "56", "Novo Selo"),
	(2301, 126, "57", "Oslomej"),
	(2302, 126, "58", "Ohrid"),
	(2303, 126, "59", "Petrovec"),
	(2304, 126, "60", "Pehčevo"),
	(2305, 126, "61", "Plasnica"),
	(2306, 126, "62", "Prilep"),
	(2307, 126, "63", "Probištip"),
	(2308, 126, "64", "Radoviš"),
	(2309, 126, "65", "Rankovce"),
	(2310, 126, "66", "Resen"),
	(2311, 126, "67", "Rosoman"),
	(2312, 126, "68", "Saraj"),
	(2313, 126, "69", "Sveti Nikole"),
	(2314, 126, "70", "Sopište"),
	(2315, 126, "71", "Staro Nagoričane"),
	(2316, 126, "72", "Struga"),
	(2317, 126, "73", "Strumica"),
	(2318, 126, "74", "Studeničani"),
	(2319, 126, "75", "Tearce"),
	(2320, 126, "76", "Tetovo"),
	(2321, 126, "77", "Centar"),
	(2322, 126, "78", "Centar Župa"),
	(2323, 126, "79", "Čair"),
	(2324, 126, "80", "Čaška"),
	(2325, 126, "81", "Češinovo-Obleševo"),
	(2326, 126, "82", "Čučer Sandevo"),
	(2327, 126, "83", "Štip"),
	(2328, 126, "84", "Šuto Orizari"),
	(2329, 127, "A", "Toamasina"),
	(2330, 127, "D", "Antsiranana"),
	(2331, 127, "F", "Fianarantsoa"),
	(2332, 127, "M", "Mahajanga"),
	(2333, 127, "T", "Antananarivo"),
	(2334, 127, "U", "Toliara"),
	(2335, 128, "BA", "Balaka"),
	(2336, 128, "BL", "Blantyre"),
	(2337, 128, "C", "Central Region"),
	(2338, 128, "CK", "Chikwawa"),
	(2339, 128, "CR", "Chiradzulu"),
	(2340, 128, "CT", "Chitipa"),
	(2341, 128, "DE", "Dedza"),
	(2342, 128, "DO", "Dowa"),
	(2343, 128, "KR", "Karonga"),
	(2344, 128, "KS", "Kasungu"),
	(2345, 128, "LI", "Lilongwe"),
	(2346, 128, "LK", "Likoma"),
	(2347, 128, "MC", "Mchinji"),
	(2348, 128, "MG", "Mangochi"),
	(2349, 128, "MH", "Machinga"),
	(2350, 128, "MU", "Mulanje"),
	(2351, 128, "MW", "Mwanza"),
	(2352, 128, "MZ", "Mzimba"),
	(2353, 128, "N", "Northern Region"),
	(2354, 128, "NB", "Nkhata Bay"),
	(2355, 128, "NE", "Neno"),
	(2356, 128, "NI", "Ntchisi"),
	(2357, 128, "NK", "Nkhotakota"),
	(2358, 128, "NS", "Nsanje"),
	(2359, 128, "NU", "Ntcheu"),
	(2360, 128, "PH", "Phalombe"),
	(2361, 128, "RU", "Rumphi"),
	(2362, 128, "S", "Southern Region"),
	(2363, 128, "SA", "Salima"),
	(2364, 128, "TH", "Thyolo"),
	(2365, 128, "ZO", "Zomba"),
	(2366, 129, "JOH", "Johor"),
	(2367, 129, "KDH", "Kedah"),
	(2368, 129, "KEL", "Kelantan"),
	(2369, 129, "KL", "Kuala Lumpur"),
	(2370, 129, "LAB", "W.P.Labuan"),
	(2371, 129, "MEL", "Melaka"),
	(2372, 129, "NS", "Negeri Sembilan"),
	(2373, 129, "PAH", "Pahang"),
	(2374, 129, "PER", "Perlis"),
	(2375, 129, "PP", "Pulau Pinang"),
	(2376, 129, "PRK", "Perak"),
	(2377, 129, "SAB", "Sabah"),
	(2378, 129, "SEL", "Selangor"),
	(2379, 129, "SWK", "Sarawak"),
	(2380, 129, "TER", "Terengganu"),
	(2381, 130, "00", "Alif Dhaal"),
	(2382, 130, "01", "Seenu"),
	(2383, 130, "02", "Alif"),
	(2384, 130, "03", "Lhaviyani"),
	(2385, 130, "04", "Vaavu"),
	(2386, 130, "05", "Laamu"),
	(2387, 130, "07", "Haa Alif"),
	(2388, 130, "08", "Thaa"),
	(2389, 130, "12", "Meemu"),
	(2390, 130, "13", "Raa"),
	(2391, 130, "14", "Faafu"),
	(2392, 130, "17", "Dhaalu"),
	(2393, 130, "20", "Baa"),
	(2394, 130, "23", "Haa Dhaalu"),
	(2395, 130, "24", "Shaviyani"),
	(2396, 130, "25", "Noonu"),
	(2397, 130, "26", "Kaafu"),
	(2398, 130, "27", "Gaaf Alif"),
	(2399, 130, "28", "Gaafu Dhaalu"),
	(2400, 130, "29", "Gnaviyani"),
	(2401, 130, "CE", "Central"),
	(2402, 130, "MLE", "Male"),
	(2403, 130, "NC", "North Central"),
	(2404, 130, "NO", "North"),
	(2405, 130, "SC", "South Central"),
	(2406, 130, "SU", "South"),
	(2407, 130, "UN", "Upper North"),
	(2408, 130, "US", "Upper South"),
	(2409, 131, "1", "Kayes"),
	(2410, 131, "2", "Koulikoro"),
	(2411, 131, "3", "Sikasso"),
	(2412, 131, "4", "Ségou"),
	(2413, 131, "5", "Mopti"),
	(2414, 131, "6", "Tombouctou"),
	(2415, 131, "7", "Gao"),
	(2416, 131, "8", "Kidal"),
	(2417, 131, "BKO", "Bamako"),
	(2418, 132, "01", "Attard"),
	(2419, 132, "02", "Balzan"),
	(2420, 132, "03", "Birgu"),
	(2421, 132, "04", "Birkirkara"),
	(2422, 132, "05", "Birżebbuġa"),
	(2423, 132, "06", "Bormla"),
	(2424, 132, "07", "Dingli"),
	(2425, 132, "08", "Fgura"),
	(2426, 132, "09", "Floriana"),
	(2427, 132, "10", "Fontana"),
	(2428, 132, "11", "Gudja"),
	(2429, 132, "12", "Gżira"),
	(2430, 132, "13", "Għajnsielem"),
	(2431, 132, "14", "Għarb"),
	(2432, 132, "15", "Għargħur"),
	(2433, 132, "16", "Għasri"),
	(2434, 132, "17", "Għaxaq"),
	(2435, 132, "18", "Ħamrun"),
	(2436, 132, "19", "Iklin"),
	(2437, 132, "20", "Isla"),
	(2438, 132, "21", "Kalkara"),
	(2439, 132, "22", "Kerċem"),
	(2440, 132, "23", "Kirkop"),
	(2441, 132, "24", "Lija"),
	(2442, 132, "25", "Luqa"),
	(2443, 132, "26", "Marsa"),
	(2444, 132, "27", "Marsaskala"),
	(2445, 132, "28", "Marsaxlokk"),
	(2446, 132, "29", "Mdina"),
	(2447, 132, "30", "Mellieħa"),
	(2448, 132, "31", "Mġarr"),
	(2449, 132, "32", "Mosta"),
	(2450, 132, "33", "Mqabba"),
	(2451, 132, "34", "Msida"),
	(2452, 132, "35", "Mtarfa"),
	(2453, 132, "36", "Munxar"),
	(2454, 132, "37", "Nadur"),
	(2455, 132, "38", "Naxxar"),
	(2456, 132, "39", "Paola"),
	(2457, 132, "40", "Pembroke"),
	(2458, 132, "41", "Pietà"),
	(2459, 132, "42", "Qala"),
	(2460, 132, "43", "Qormi"),
	(2461, 132, "44", "Qrendi"),
	(2462, 132, "45", "Rabat Għawdex(mt)"),
	(2463, 132, "46", "Rabat Malta"),
	(2464, 132, "47", "Safi"),
	(2465, 132, "48", "San Ġiljan"),
	(2466, 132, "49", "San Ġwann"),
	(2467, 132, "50", "San Lawrenz"),
	(2468, 132, "51", "San Pawl il-Baħar"),
	(2469, 132, "52", "Sannat"),
	(2470, 132, "53", "Santa Luċija"),
	(2471, 132, "54", "Santa Venera"),
	(2472, 132, "55", "Siġġiewi"),
	(2473, 132, "56", "Sliema"),
	(2474, 132, "57", "Swieqi"),
	(2475, 132, "58", "Ta’ Xbiex"),
	(2476, 132, "59", "Tarxien"),
	(2477, 132, "60", "Valletta"),
	(2478, 132, "61", "Xagħra"),
	(2479, 132, "62", "Xewkija"),
	(2480, 132, "63", "Xgħajra"),
	(2481, 132, "64", "Żabbar"),
	(2482, 132, "65", "Żebbuġ Għawdex"),
	(2483, 132, "66", "Żebbuġ Malta"),
	(2484, 132, "67", "Żejtun"),
	(2485, 132, "68", "Żurrieq"),
	(2486, 133, "ALK", "Ailuk"),
	(2487, 133, "ALL", "Ailinglaplap"),
	(2488, 133, "ARN", "Arno"),
	(2489, 133, "AUR", "Aur"),
	(2490, 133, "EBO", "Ebon"),
	(2491, 133, "ENI", "Enewetak"),
	(2492, 133, "JAB", "Jabat"),
	(2493, 133, "JAL", "Jaluit"),
	(2494, 133, "KIL", "Kili"),
	(2495, 133, "KWA", "Kwajalein"),
	(2496, 133, "L", "Ralik chain"),
	(2497, 133, "LAE", "Lae"),
	(2498, 133, "LIB", "Lib"),
	(2499, 133, "LIK", "Likiep"),
	(2500, 133, "MAJ", "Majuro"),
	(2501, 133, "MAL", "Maloelap"),
	(2502, 133, "MEJ", "Mejit"),
	(2503, 133, "MIL", "Mili"),
	(2504, 133, "NMK", "Namdrik"),
	(2505, 133, "NMU", "Namu"),
	(2506, 133, "RON", "Rongelap"),
	(2507, 133, "T", "Ratak chain"),
	(2508, 133, "UJA", "Ujae"),
	(2509, 133, "UTI", "Utirik"),
	(2510, 133, "WTH", "Wotho"),
	(2511, 133, "WTJ", "Wotje"),
	(2512, 135, "01", "Hodh ech Chargui"),
	(2513, 135, "02", "Hodh el Gharbi"),
	(2514, 135, "03", "Assaba"),
	(2515, 135, "04", "Gorgol"),
	(2516, 135, "05", "Brakna"),
	(2517, 135, "06", "Trarza"),
	(2518, 135, "07", "Adrar"),
	(2519, 135, "08", "Dakhlet Nouâdhibou"),
	(2520, 135, "09", "Tagant"),
	(2521, 135, "10", "Guidimaka"),
	(2522, 135, "11", "Tiris Zemmour"),
	(2523, 135, "12", "Inchiri"),
	(2524, 135, "NKC", "Nouakchott"),
	(2525, 136, "AG", "Agalega Islands"),
	(2526, 136, "BL", "Black River"),
	(2527, 136, "BR", "Beau Bassin-Rose Hill"),
	(2528, 136, "CC", "Cargados Carajos Shoals [Saint Brandon Islands]"),
	(2529, 136, "CU", "Curepipe"),
	(2530, 136, "FL", "Flacq"),
	(2531, 136, "GP", "Grand Port"),
	(2532, 136, "MO", "Moka"),
	(2533, 136, "PA", "Pamplemousses"),
	(2534, 136, "PL", "Port Louis City"),
	(2535, 136, "PU", "Port Louis District"),
	(2536, 136, "PW", "Plaines Wilhems"),
	(2537, 136, "QB", "Quatre Bornes"),
	(2538, 136, "RO", "Rodrigues Island"),
	(2539, 136, "RR", "Rivière du Rempart"),
	(2540, 136, "SA", "Savanne"),
	(2541, 136, "VP", "Vacoas-Phoenix"),
	(2542, 138, "AGU", "Aguascalientes"),
	(2543, 138, "BCN", "Baja California"),
	(2544, 138, "BCS", "Baja California Sur"),
	(2545, 138, "CAM", "Campeche"),
	(2546, 138, "CHH", "Chihuahua"),
	(2547, 138, "CHP", "Chiapas"),
	(2548, 138, "COA", "Coahuila"),
	(2549, 138, "COL", "Colima"),
	(2550, 138, "DIF", "Distrito Federal"),
	(2551, 138, "DUR", "Durango"),
	(2552, 138, "GRO", "Guerrero"),
	(2553, 138, "GUA", "Guanajuato"),
	(2554, 138, "HID", "Hidalgo"),
	(2555, 138, "JAL", "Jalisco"),
	(2556, 138, "MEX", "México"),
	(2557, 138, "MIC", "Michoacán"),
	(2558, 138, "MOR", "Morelos"),
	(2559, 138, "NAY", "Nayarit"),
	(2560, 138, "NLE", "Nuevo León"),
	(2561, 138, "OAX", "Oaxaca"),
	(2562, 138, "PUE", "Puebla"),
	(2563, 138, "QUE", "Querétaro"),
	(2564, 138, "ROO", "Quintana Roo"),
	(2565, 138, "SIN", "Sinaloa"),
	(2566, 138, "SLP", "San Luis Potosí"),
	(2567, 138, "SON", "Sonora"),
	(2568, 138, "TAB", "Tabasco"),
	(2569, 138, "TAM", "Tamaulipas"),
	(2570, 138, "TLA", "Tlaxcala"),
	(2571, 138, "VER", "Veracruz"),
	(2572, 138, "YUC", "Yucatán"),
	(2573, 138, "ZAC", "Zacatecas"),
	(2574, 139, "KSA", "Kosrae"),
	(2575, 139, "PNI", "Pohnpei"),
	(2576, 139, "TRK", "Chuuk"),
	(2577, 139, "YAP", "Yap"),
	(2578, 140, "AN", "Anenii Noi"),
	(2579, 140, "BA", "Bălţi"),
	(2580, 140, "BD", "Tighina"),
	(2581, 140, "BR", "Briceni"),
	(2582, 140, "BS", "Basarabeasca"),
	(2583, 140, "CA", "Cahul"),
	(2584, 140, "CL", "Călăraşi"),
	(2585, 140, "CM", "Cimişlia"),
	(2586, 140, "CR", "Criuleni"),
	(2587, 140, "CS", "Căuşeni"),
	(2588, 140, "CT", "Cantemir"),
	(2589, 140, "CU", "Chisinau"),
	(2590, 140, "DO", "Donduşeni"),
	(2591, 140, "DR", "Drochia"),
	(2592, 140, "DU", "Dubăsari"),
	(2593, 140, "ED", "Edinet"),
	(2594, 140, "FA", "Făleşti"),
	(2595, 140, "FL", "Floreşti"),
	(2596, 140, "GA", "Gagauzia, Unitatea teritoriala autonoma (UTAG)"),
	(2597, 140, "GL", "Glodeni"),
	(2598, 140, "HI", "Hînceşti"),
	(2599, 140, "IA", "Ialoveni"),
	(2600, 140, "LE", "Leova"),
	(2601, 140, "NI", "Nisporeni"),
	(2602, 140, "OC", "Ocniţa"),
	(2603, 140, "OR", "Orhei"),
	(2604, 140, "RE", "Rezina"),
	(2605, 140, "RI", "Rîşcani"),
	(2606, 140, "SD", "Şoldăneşti"),
	(2607, 140, "SI", "Sîngerei"),
	(2608, 140, "SN", "Stînga Nistrului, unitatea teritoriala din"),
	(2609, 140, "SO", "Soroca"),
	(2610, 140, "ST", "Străşeni"),
	(2611, 140, "SV", "Ştefan Vodă"),
	(2612, 140, "TA", "Taraclia"),
	(2613, 140, "TE", "Teleneşti"),
	(2614, 140, "UN", "Ungheni"),
	(2615, 141, "CL", "La Colle"),
	(2616, 141, "CO", "La Condamine"),
	(2617, 141, "FO", "Fontvieille"),
	(2618, 141, "GA", "La Gare"),
	(2619, 141, "JE", "Jardin Exotique"),
	(2620, 141, "LA", "Larvotto"),
	(2621, 141, "MA", "Malbousquet"),
	(2622, 141, "MC", "Monte-Carlo"),
	(2623, 141, "MG", "Moneghetti"),
	(2624, 141, "MO", "Monaco-Ville"),
	(2625, 141, "MU", "Moulins"),
	(2626, 141, "PH", "Port-Hercule"),
	(2627, 141, "SD", "Sainte-Dévote"),
	(2628, 141, "SO", "La Source"),
	(2629, 141, "SP", "Spélugues"),
	(2630, 141, "SR", "Saint-Roman"),
	(2631, 141, "VR", "Vallon de la Rousse"),
	(2632, 142, "035", "Orhon"),
	(2633, 142, "037", "Darhan uul"),
	(2634, 142, "039", "Hentiy"),
	(2635, 142, "041", "Hövsgöl"),
	(2636, 142, "043", "Hovd"),
	(2637, 142, "046", "Uvs"),
	(2638, 142, "047", "Töv"),
	(2639, 142, "049", "Selenge"),
	(2640, 142, "051", "Sühbaatar"),
	(2641, 142, "053", "Ömnögovi"),
	(2642, 142, "055", "Övörhangay"),
	(2643, 142, "057", "Dzavhan"),
	(2644, 142, "059", "Dundgovi"),
	(2645, 142, "061", "Dornod"),
	(2646, 142, "063", "Dornogovi"),
	(2647, 142, "064", "Govi-Sümber"),
	(2648, 142, "065", "Govi-Altay"),
	(2649, 142, "067", "Bulgan"),
	(2650, 142, "069", "Bayanhongor"),
	(2651, 142, "071", "Bayan-Ölgiy"),
	(2652, 142, "073", "Arhangay"),
	(2653, 142, "1", "Ulaanbaatar"),
	(2654, 144, "01", "Tanger-Tetouan"),
	(2655, 144, "02", "Gharb-Chrarda-Beni Hssen"),
	(2656, 144, "03", "Taza-Al Hoceima-Taounate"),
	(2657, 144, "04", "L'Oriental"),
	(2658, 144, "05", "Fes-Boulemane"),
	(2659, 144, "06", "Meknes-Tafilalet"),
	(2660, 144, "07", "Rabat-Salé-Zemmour-Zaer"),
	(2661, 144, "08", "Grand Casablanca"),
	(2662, 144, "09", "Chaouia-Ouardigh"),
	(2663, 144, "10", "Doukkala-Abda"),
	(2664, 144, "11", "Marrakech-Tensift-Al Haouz"),
	(2665, 144, "12", "Tadla-Azilal"),
	(2666, 144, "13", "Souss-Massa-Draa"),
	(2667, 144, "14", "Guelmim-Es Smar"),
	(2668, 144, "15", "Laayoune-Boujdour-Sakia El Hamra"),
	(2669, 144, "16", "Oued ed Dahab-Lagouira"),
	(2670, 144, "AGD", "Agadir-Ida-Outanane"),
	(2671, 144, "AOU", "Aousserd"),
	(2672, 144, "ASZ", "Assa-Zag"),
	(2673, 144, "AZI", "Azilal"),
	(2674, 144, "BEM", "Beni Mellal"),
	(2675, 144, "BER", "Berkane"),
	(2676, 144, "BES", "Ben Slimane"),
	(2677, 144, "BOD", "Boujdour (EH)"),
	(2678, 144, "BOM", "Boulemane"),
	(2679, 144, "CAS", "Casablanca [Dar el Beïda]*"),
	(2680, 144, "CHE", "Chefchaouen"),
	(2681, 144, "CHI", "Chichaoua"),
	(2682, 144, "CHT", "Chtouka-Ait Baha"),
	(2683, 144, "ERR", "Errachidia"),
	(2684, 144, "ESI", "Essaouira"),
	(2685, 144, "ESM", "Es Smara (EH)"),
	(2686, 144, "FAH", "Fahs-Beni Makada "),
	(2687, 144, "FES", "Fès-Dar-Dbibegh"),
	(2688, 144, "FIG", "Figuig"),
	(2689, 144, "GUE", "Guelmim"),
	(2690, 144, "HAJ", "El Hajeb"),
	(2691, 144, "HAO", "Al Haouz"),
	(2692, 144, "HOC", "Al Hoceïma"),
	(2693, 144, "IFR", "Ifrane"),
	(2694, 144, "INE", "Inezgane-Ait Melloul "),
	(2695, 144, "JDI", "El Jadida"),
	(2696, 144, "JRA", "Jrada"),
	(2697, 144, "KEN", "Kénitra"),
	(2698, 144, "KES", "Kelaat es Sraghna"),
	(2699, 144, "KHE", "Khemisset"),
	(2700, 144, "KHN", "Khenifra"),
	(2701, 144, "KHO", "Khouribga"),
	(2702, 144, "LAA", "Laâyoune*"),
	(2703, 144, "LAR", "Larache"),
	(2704, 144, "MED", "Mediouna"),
	(2705, 144, "MEK", "Meknès"),
	(2706, 144, "MMD", "Marrakech-Medina "),
	(2707, 144, "MMN", "Marrakech-Menara "),
	(2708, 144, "MOH", "Mohammadia "),
	(2709, 144, "MOU", "Moulay Yacoub"),
	(2710, 144, "NAD", "Nador"),
	(2711, 144, "NOU", "Nouaceur"),
	(2712, 144, "OUA", "Ouarzazate"),
	(2713, 144, "OUD", "Oued ed Dahab (EH)"),
	(2714, 144, "OUJ", "Oujda*"),
	(2715, 144, "RAB", "Rabat"),
	(2716, 144, "SAF", "Safi"),
	(2717, 144, "SAL", "Connaught Salé"),
	(2718, 144, "SEF", "Sefrou"),
	(2719, 144, "SET", "Settat"),
	(2720, 144, "SIK", "Sidi Kacem"),
	(2721, 144, "SKH", "Skhirate-Témara"),
	(2722, 144, "SYB", "Sidi Youssef Ben Ali "),
	(2723, 144, "TAI", "Taourirt"),
	(2724, 144, "TAO", "Taounate"),
	(2725, 144, "TAR", "Taroudant"),
	(2726, 144, "TAT", "Tata"),
	(2727, 144, "TAZ", "Taza"),
	(2728, 144, "TIZ", "Tiznit"),
	(2729, 144, "TNG", "Tanger-Assilah "),
	(2730, 144, "TNT", "Tan-Tan"),
	(2731, 144, "ZAG", "Zagora"),
	(2732, 145, "A", "Niassa"),
	(2733, 145, "B", "Manica"),
	(2734, 145, "G", "Gaza"),
	(2735, 145, "I", "Inhambane"),
	(2736, 145, "L", "Maputo"),
	(2737, 145, "MPM", "Maputo City"),
	(2738, 145, "N", "Nampula"),
	(2739, 145, "P", "Cabo Delgado"),
	(2740, 145, "Q", "Zambézia"),
	(2741, 145, "S", "Sofala"),
	(2742, 145, "T", "Tete"),
	(2743, 146, "01", "Sagaing"),
	(2744, 146, "02", "Bago"),
	(2745, 146, "03", "Magway"),
	(2746, 146, "04", "Mandalay"),
	(2747, 146, "05", "Tanintharyi"),
	(2748, 146, "06", "Yangon"),
	(2749, 146, "07", "Ayeyarwady"),
	(2750, 146, "11", "Kachin"),
	(2751, 146, "12", "Kayah"),
	(2752, 146, "13", "Kayin"),
	(2753, 146, "14", "Chin"),
	(2754, 146, "15", "Mon"),
	(2755, 146, "16", "Rakhine"),
	(2756, 146, "17", "Shan"),
	(2757, 147, "CA", "Caprivi"),
	(2758, 147, "ER", "Erongo"),
	(2759, 147, "HA", "Hardap"),
	(2760, 147, "KA", "Karas"),
	(2761, 147, "KH", "Khomas"),
	(2762, 147, "KU", "Kunene"),
	(2763, 147, "OD", "Otjozondjupa"),
	(2764, 147, "OH", "Omaheke"),
	(2765, 147, "OK", "Okavango"),
	(2766, 147, "ON", "Oshana"),
	(2767, 147, "OS", "Omusati"),
	(2768, 147, "OT", "Oshikoto"),
	(2769, 147, "OW", "Ohangwena"),
	(2770, 148, "01", "Aiwo"),
	(2771, 148, "02", "Anabar"),
	(2772, 148, "03", "Anetan"),
	(2773, 148, "04", "Anibare"),
	(2774, 148, "05", "Baiti"),
	(2775, 148, "06", "Boe"),
	(2776, 148, "07", "Buada"),
	(2777, 148, "08", "Denigomodu"),
	(2778, 148, "09", "Ewa"),
	(2779, 148, "10", "Ijuw"),
	(2780, 148, "11", "Meneng"),
	(2781, 148, "12", "Nibok"),
	(2782, 148, "13", "Uaboe"),
	(2783, 148, "14", "Yaren"),
	(2784, 149, "1", "Madhyamanchal"),
	(2785, 149, "2", "Madhya Pashchimanchal"),
	(2786, 149, "3", "Pashchimanchal"),
	(2787, 149, "4", "Purwanchal"),
	(2788, 149, "5", "Sudur Pashchimanchal"),
	(2789, 149, "BA", "Bagmati"),
	(2790, 149, "BH", "Bheri"),
	(2791, 149, "DH", "Dhawalagiri"),
	(2792, 149, "GA", "Gandaki"),
	(2793, 149, "JA", "Janakpur"),
	(2794, 149, "KA", "Karnali"),
	(2795, 149, "KO", "Kosi [Koshi]"),
	(2796, 149, "LU", "Lumbini"),
	(2797, 149, "MA", "Mahakali"),
	(2798, 149, "ME", "Mechi"),
	(2799, 149, "NA", "Narayani"),
	(2800, 149, "RA", "Rapti"),
	(2801, 149, "SA", "Sagarmatha"),
	(2802, 149, "SE", "Seti"),
	(2803, 150, "DRE", "Drenthe"),
	(2804, 150, "FLE", "Flevoland"),
	(2805, 150, "FRI", "Friesland"),
	(2806, 150, "GEL", "Gelderland"),
	(2807, 150, "GRN", "Groningen"),
	(2808, 150, "LIM", "Limburg"),
	(2809, 150, "NOB", "Noord-Brabant"),
	(2810, 150, "NOH", "Noord-Holland"),
	(2811, 150, "OVI", "Overijssel"),
	(2812, 150, "UTR", "Utrecht"),
	(2813, 150, "ZEE", "Zeeland"),
	(2814, 150, "ZOH", "Zuid-Holland"),
	(2815, 153, "AUK", "Auckland"),
	(2816, 153, "BOP", "Bay of Plenty"),
	(2817, 153, "CAN", "Canterbury"),
	(2818, 153, "GIS", "Gisborne"),
	(2819, 153, "HKB", "Hawke's Bay"),
	(2820, 153, "MBH", "Marlborough District"),
	(2821, 153, "MWT", "Manawatu-Wanganui"),
	(2822, 153, "NSN", "Nelson City"),
	(2823, 153, "NTL", "Northland"),
	(2824, 153, "OTA", "Otago"),
	(2825, 153, "STL", "Southland"),
	(2826, 153, "TAS", "Tasman District"),
	(2827, 153, "TKI", "Taranaki"),
	(2828, 153, "WGN", "Wellington"),
	(2829, 153, "WKO", "Waikato"),
	(2830, 153, "WTC", "West Coast"),
	(2831, 154, "AN", "Atlántico Norte*"),
	(2832, 154, "AS", "Atlántico Sur*"),
	(2833, 154, "BO", "Boaco"),
	(2834, 154, "CA", "Carazo"),
	(2835, 154, "CI", "Chinandega"),
	(2836, 154, "CO", "Chontales"),
	(2837, 154, "ES", "Estelí"),
	(2838, 154, "GR", "Granada"),
	(2839, 154, "JI", "Jinotega"),
	(2840, 154, "LE", "León"),
	(2841, 154, "MD", "Madriz"),
	(2842, 154, "MN", "Managua"),
	(2843, 154, "MS", "Masaya"),
	(2844, 154, "MT", "Matagalpa"),
	(2845, 154, "NS", "Nueva Segovia"),
	(2846, 154, "RI", "Rivas"),
	(2847, 154, "SJ", "Río San Juan"),
	(2848, 155, "1", "Agadez"),
	(2849, 155, "2", "Diffa"),
	(2850, 155, "3", "Dosso"),
	(2851, 155, "4", "Maradi"),
	(2852, 155, "5", "Tahoua"),
	(2853, 155, "6", "Tillabéri"),
	(2854, 155, "7", "Zinder"),
	(2855, 155, "8", "Niamey"),
	(2856, 156, "AB", "Abia"),
	(2857, 156, "AD", "Adamawa"),
	(2858, 156, "AK", "Akwa Ibom"),
	(2859, 156, "AN", "Anambra"),
	(2860, 156, "BA", "Bauchi"),
	(2861, 156, "BE", "Benue"),
	(2862, 156, "BO", "Borno"),
	(2863, 156, "BY", "Bayelsa"),
	(2864, 156, "CR", "Cross River"),
	(2865, 156, "DE", "Delta"),
	(2866, 156, "EB", "Ebonyi"),
	(2867, 156, "ED", "Edo"),
	(2868, 156, "EK", "Ekiti"),
	(2869, 156, "EN", "Enugu"),
	(2870, 156, "FC", "Abuja Federal Capital Territory"),
	(2871, 156, "GO", "Gombe"),
	(2872, 156, "IM", "Imo"),
	(2873, 156, "JI", "Jigawa"),
	(2874, 156, "KD", "Kaduna"),
	(2875, 156, "KE", "Kebbi"),
	(2876, 156, "KN", "Kano"),
	(2877, 156, "KO", "Kogi"),
	(2878, 156, "KT", "Katsina"),
	(2879, 156, "KW", "Kwara"),
	(2880, 156, "LA", "Lagos"),
	(2881, 156, "NA", "Nassarawa"),
	(2882, 156, "NI", "Niger"),
	(2883, 156, "OG", "Ogun"),
	(2884, 156, "ON", "Ondo"),
	(2885, 156, "OS", "Osun"),
	(2886, 156, "OY", "Oyo"),
	(2887, 156, "PL", "Plateau"),
	(2888, 156, "RI", "Rivers"),
	(2889, 156, "SO", "Sokoto"),
	(2890, 156, "TA", "Taraba"),
	(2891, 156, "YO", "Yobe"),
	(2892, 156, "ZA", "Zamfara"),
	(2893, 160, "AKE", "Akershus"),
	(2894, 160, "AUA", "Aust-Agder"),
	(2895, 160, "BUS", "Buskerud"),
	(2896, 160, "FIN", "Finnmark"),
	(2897, 160, "HED", "Hedmark"),
	(2898, 160, "HOR", "Hordaland"),
	(2899, 160, "MOR", "Møre og Romsdal"),
	(2900, 160, "NOR", "Nordland"),
	(2901, 160, "NTR", "Nord-Trøndelag"),
	(2902, 160, "OPP", "Oppland"),
	(2903, 160, "OSL", "Oslo"),
	(2904, 160, "OST", "Østfold"),
	(2905, 160, "ROG", "Rogaland"),
	(2906, 160, "SOF", "Sogn og Fjordane"),
	(2907, 160, "STR", "Sør-Trøndelag"),
	(2908, 160, "SVA", "Svalbard"),
	(2909, 160, "TEL", "Telemark"),
	(2910, 160, "TRO", "Troms"),
	(2911, 160, "VEA", "Vest-Agder"),
	(2912, 161, "BA", "Al Batinah"),
	(2913, 161, "BU", "Al Buraymi"),
	(2914, 161, "DA", "Ad Dakhiliyah"),
	(2915, 161, "MA", "Masqat"),
	(2916, 161, "MU", "Musandam"),
	(2917, 161, "SH", "Ash Sharqiyah"),
	(2918, 161, "WU", "Al Wustá"),
	(2919, 161, "ZA", "Az̧ Z̧āhirah"),
	(2920, 161, "ZU", "Z̧ufār"),
	(2921, 162, "BA", "Baluchistan (en)"),
	(2922, 162, "GB", "Gilgit-Baltistan"),
	(2923, 162, "IS", "Islamabad"),
	(2924, 162, "JK", "Azad Kashmir"),
	(2925, 162, "KP", "Khyber Pakhtunkhwa"),
	(2926, 162, "PB", "Punjab"),
	(2927, 162, "SD", "Sindh"),
	(2928, 162, "TA", "Federally Administered Tribal Areas"),
	(2929, 163, "002", "Aimeliik"),
	(2930, 163, "004", "Airai"),
	(2931, 163, "010", "Angaur"),
	(2932, 163, "050", "Hatobohei"),
	(2933, 163, "100", "Kayangel"),
	(2934, 163, "150", "Koror"),
	(2935, 163, "212", "Melekeok"),
	(2936, 163, "214", "Ngaraard"),
	(2937, 163, "218", "Ngarchelong"),
	(2938, 163, "222", "Ngardmau"),
	(2939, 163, "224", "Ngatpang"),
	(2940, 163, "226", "Ngchesar"),
	(2941, 163, "227", "Ngeremlengui"),
	(2942, 163, "228", "Ngiwal"),
	(2943, 163, "350", "Peleliu"),
	(2944, 163, "370", "Sonsorol"),
	(2945, 164, "1", "Bocas del Toro"),
	(2946, 164, "2", "Coclé"),
	(2947, 164, "3", "Colón"),
	(2948, 164, "4", "Chiriquí"),
	(2949, 164, "5", "Darién"),
	(2950, 164, "6", "Herrera"),
	(2951, 164, "7", "Los Santos"),
	(2952, 164, "8", "Panamá"),
	(2953, 164, "9", "Veraguas"),
	(2954, 164, "EM", "Emberá"),
	(2955, 164, "KY", "Kuna Yala"),
	(2956, 164, "NB", "Ngöbe-Buglé"),
	(2957, 165, "CPK", "Chimbu"),
	(2958, 165, "CPM", "Central"),
	(2959, 165, "EBR", "East New Britain"),
	(2960, 165, "EHG", "Eastern Highlands"),
	(2961, 165, "EPW", "Enga"),
	(2962, 165, "ESW", "East Sepik"),
	(2963, 165, "GPK", "Gulf"),
	(2964, 165, "MBA", "Milne Bay"),
	(2965, 165, "MPL", "Morobe"),
	(2966, 165, "MPM", "Madang"),
	(2967, 165, "MRL", "Manus"),
	(2968, 165, "NCD", "National Capital District (Port Moresby)"),
	(2969, 165, "NIK", "New Ireland"),
	(2970, 165, "NPP", "Northern"),
	(2971, 165, "NSB", "Bougainville"),
	(2972, 165, "SAN", "Sandaun [West Sepik]"),
	(2973, 165, "SHM", "Southern Highlands"),
	(2974, 165, "WBK", "West New Britain"),
	(2975, 165, "WHM", "Western Highlands"),
	(2976, 165, "WPD", "Western"),
	(2977, 166, "1", "Concepción"),
	(2978, 166, "10", "Alto Paraná"),
	(2979, 166, "11", "Central"),
	(2980, 166, "12", "Ñeembucú"),
	(2981, 166, "13", "Amambay"),
	(2982, 166, "14", "Canindeyú"),
	(2983, 166, "15", "Presidente Hayes"),
	(2984, 166, "16", "Alto Paraguay"),
	(2985, 166, "19", "Boquerón"),
	(2986, 166, "2", "San Pedro"),
	(2987, 166, "3", "Cordillera"),
	(2988, 166, "4", "Guairá"),
	(2989, 166, "5", "Caaguazú"),
	(2990, 166, "6", "Caazapá"),
	(2991, 166, "7", "Itapúa"),
	(2992, 166, "8", "Misiones"),
	(2993, 166, "9", "Paraguarí"),
	(2994, 166, "ASU", "Asunción"),
	(2995, 167, "AMA", "Amazonas"),
	(2996, 167, "ANC", "Ancash"),
	(2997, 167, "APU", "Apurímac"),
	(2998, 167, "ARE", "Arequipa"),
	(2999, 167, "AYA", "Ayacucho"),
	(3000, 167, "CAJ", "Cajamarca"),
	(3001, 167, "CAL", "El Callao"),
	(3002, 167, "CUS", "Cusco [Cuzco]"),
	(3003, 167, "HUC", "Huánuco"),
	(3004, 167, "HUV", "Huancavelica"),
	(3005, 167, "ICA", "Ica"),
	(3006, 167, "JUN", "Junín"),
	(3007, 167, "LAL", "La Libertad"),
	(3008, 167, "LAM", "Lambayeque"),
	(3009, 167, "LIM", "Lima"),
	(3010, 167, "LMA", "Municipalidad Metropolitana de Lima"),
	(3011, 167, "LOR", "Loreto"),
	(3012, 167, "MDD", "Madre de Dios"),
	(3013, 167, "MOQ", "Moquegua"),
	(3014, 167, "PAS", "Pasco"),
	(3015, 167, "PIU", "Piura"),
	(3016, 167, "PUN", "Puno"),
	(3017, 167, "SAM", "San Martín"),
	(3018, 167, "TAC", "Tacna"),
	(3019, 167, "TUM", "Tumbes"),
	(3020, 167, "UCA", "Ucayali"),
	(3021, 168, "00", "National Capital Region"),
	(3022, 168, "01", "Ilocos (Region I)"),
	(3023, 168, "02", "Cagayan Valley (Region II)"),
	(3024, 168, "03", "Central Luzon (Region III)"),
	(3025, 168, "05", "Bicol (Region V)"),
	(3026, 168, "06", "Western Visayas (Region VI)"),
	(3027, 168, "07", "Central Visayas (Region VII)"),
	(3028, 168, "08", "Eastern Visayas (Region VIII)"),
	(3029, 168, "09", "Zamboanga Peninsula (Region IX)"),
	(3030, 168, "10", "Northern Mindanao (Region X)"),
	(3031, 168, "11", "Davao (Region XI)"),
	(3032, 168, "12", "Soccsksargen (Region XII)"),
	(3033, 168, "13", "Caraga (Region XIII)"),
	(3034, 168, "14", "Autonomous Region in Muslim Mindanao (ARMM)"),
	(3035, 168, "15", "Cordillera Administrative Region (CAR)"),
	(3036, 168, "40", "CALABARZON (Region IV-A)"),
	(3037, 168, "41", "MIMAROPA (Region IV-B)"),
	(3038, 168, "ABR", "Abra"),
	(3039, 168, "AGN", "Agusan del Norte"),
	(3040, 168, "AGS", "Agusan del Sur"),
	(3041, 168, "AKL", "Aklan"),
	(3042, 168, "ALB", "Albay"),
	(3043, 168, "ANT", "Antique"),
	(3044, 168, "APA", "Apayao"),
	(3045, 168, "AUR", "Aurora"),
	(3046, 168, "BAN", "Bataan"),
	(3047, 168, "BAS", "Basilan"),
	(3048, 168, "BEN", "Benguet"),
	(3049, 168, "BIL", "Biliran"),
	(3050, 168, "BOH", "Bohol"),
	(3051, 168, "BTG", "Batangas"),
	(3052, 168, "BTN", "Batanes"),
	(3053, 168, "BUK", "Bukidnon"),
	(3054, 168, "BUL", "Bulacan"),
	(3055, 168, "CAG", "Cagayan"),
	(3056, 168, "CAM", "Camiguin"),
	(3057, 168, "CAN", "Camarines Norte"),
	(3058, 168, "CAP", "Capiz"),
	(3059, 168, "CAS", "Camarines Sur"),
	(3060, 168, "CAT", "Catanduanes"),
	(3061, 168, "CAV", "Cavite"),
	(3062, 168, "CEB", "Cebu"),
	(3063, 168, "COM", "Compostela Valley"),
	(3064, 168, "DAO", "Davao Oriental"),
	(3065, 168, "DAS", "Davao del Sur"),
	(3066, 168, "DAV", "Davao del Norte"),
	(3067, 168, "DIN", "Dinagat Islands"),
	(3068, 168, "EAS", "Eastern Samar"),
	(3069, 168, "GUI", "Guimaras"),
	(3070, 168, "IFU", "Ifugao"),
	(3071, 168, "ILI", "Iloilo"),
	(3072, 168, "ILN", "Ilocos Norte"),
	(3073, 168, "ILS", "Ilocos Sur"),
	(3074, 168, "ISA", "Isabela"),
	(3075, 168, "KAL", "Kalinga"),
	(3076, 168, "LAG", "Laguna"),
	(3077, 168, "LAN", "Lanao del Norte"),
	(3078, 168, "LAS", "Lanao del Sur"),
	(3079, 168, "LEY", "Leyte"),
	(3080, 168, "LUN", "La Union"),
	(3081, 168, "MAD", "Marinduque"),
	(3082, 168, "MAG", "Maguindanao"),
	(3083, 168, "MAS", "Masbate"),
	(3084, 168, "MDC", "Mindoro Occidental"),
	(3085, 168, "MDR", "Mindoro Oriental"),
	(3086, 168, "MOU", "Mountain Province"),
	(3087, 168, "MSC", "Misamis Occidental"),
	(3088, 168, "MSR", "Misamis Oriental"),
	(3089, 168, "NCO", "Cotabato"),
	(3090, 168, "NEC", "Negros Occidental"),
	(3091, 168, "NER", "Negros Oriental"),
	(3092, 168, "NSA", "Northern Samar"),
	(3093, 168, "NUE", "Nueva Ecija"),
	(3094, 168, "NUV", "Nueva Vizcaya"),
	(3095, 168, "PAM", "Pampanga"),
	(3096, 168, "PAN", "Pangasinan"),
	(3097, 168, "PLW", "Palawan"),
	(3098, 168, "QUE", "Quezon"),
	(3099, 168, "QUI", "Quirino"),
	(3100, 168, "RIZ", "Rizal"),
	(3101, 168, "ROM", "Romblon"),
	(3102, 168, "SAR", "Sarangani"),
	(3103, 168, "SCO", "South Cotabato"),
	(3104, 168, "SIG", "Siquijor"),
	(3105, 168, "SLE", "Southern Leyte"),
	(3106, 168, "SLU", "Sulu"),
	(3107, 168, "SOR", "Sorsogon"),
	(3108, 168, "SUK", "Sultan Kudarat"),
	(3109, 168, "SUN", "Surigao del Norte"),
	(3110, 168, "SUR", "Surigao del Sur"),
	(3111, 168, "TAR", "Tarlac"),
	(3112, 168, "TAW", "Tawi-Tawi"),
	(3113, 168, "WSA", "Western Samar"),
	(3114, 168, "X2~", "Shariff Kabunsuan"),
	(3115, 168, "ZAN", "Zamboanga del Norte"),
	(3116, 168, "ZAS", "Zamboanga del Sur"),
	(3117, 168, "ZMB", "Zambales"),
	(3118, 168, "ZSI", "Zamboanga Sibuguey [Zamboanga Sibugay]"),
	(3119, 170, "DS", "Dolnoslaskie"),
	(3120, 170, "KP", "Kujawsko-pomorskie"),
	(3121, 170, "LB", "Lubuskie"),
	(3122, 170, "LD", "Lódzkie"),
	(3123, 170, "LU", "Lubelskie"),
	(3124, 170, "MA", "Malopolskie"),
	(3125, 170, "MZ", "Mazowieckie"),
	(3126, 170, "OP", "Opolskie"),
	(3127, 170, "PD", "Podlaskie"),
	(3128, 170, "PK", "Podkarpackie"),
	(3129, 170, "PM", "Pomorskie"),
	(3130, 170, "SK", "Swietokrzyskie"),
	(3131, 170, "SL", "Slaskie"),
	(3132, 170, "WN", "Warminsko-mazurskie"),
	(3133, 170, "WP", "Wielkopolskie"),
	(3134, 170, "ZP", "Zachodniopomorskie"),
	(3135, 171, "01", "Aveiro"),
	(3136, 171, "02", "Beja"),
	(3137, 171, "03", "Braga"),
	(3138, 171, "04", "Bragança"),
	(3139, 171, "05", "Castelo Branco"),
	(3140, 171, "06", "Coimbra"),
	(3141, 171, "07", "Évora"),
	(3142, 171, "08", "Faro"),
	(3143, 171, "09", "Guarda"),
	(3144, 171, "10", "Leiria"),
	(3145, 171, "11", "Lisboa"),
	(3146, 171, "12", "Portalegre"),
	(3147, 171, "13", "Porto"),
	(3148, 171, "14", "Santarém"),
	(3149, 171, "15", "Setúbal"),
	(3150, 171, "16", "Viana do Castelo"),
	(3151, 171, "17", "Vila Real"),
	(3152, 171, "18", "Viseu"),
	(3153, 171, "20", "Região Autónoma dos Açores"),
	(3154, 171, "30", "Região Autónoma da Madeira"),
	(3155, 173, "DA", "Ad Dawhah"),
	(3156, 173, "KH", "Al Khawr wa adh Dhakhīrah"),
	(3157, 173, "MS", "Madinat ash Shamal"),
	(3158, 173, "RA", "Ar Rayyan"),
	(3159, 173, "US", "Umm Salal"),
	(3160, 173, "WA", "Al Wakrah"),
	(3161, 173, "X1~", "Umm Sa'id"),
	(3162, 173, "ZA", "Az̧ Z̧a‘āyin"),
	(3163, 175, "AB", "Alba"),
	(3164, 175, "AG", "Arges"),
	(3165, 175, "AR", "Arad"),
	(3166, 175, "B", "Bucuresti"),
	(3167, 175, "BC", "Bacau"),
	(3168, 175, "BH", "Bihor"),
	(3169, 175, "BN", "Bistrita-Nasaud"),
	(3170, 175, "BR", "Braila"),
	(3171, 175, "BT", "Botosani"),
	(3172, 175, "BV", "Brasov"),
	(3173, 175, "BZ", "Buzau"),
	(3174, 175, "CJ", "Cluj"),
	(3175, 175, "CL", "Calarasi"),
	(3176, 175, "CS", "Caras-Severin"),
	(3177, 175, "CT", "Constanta"),
	(3178, 175, "CV", "Covasna"),
	(3179, 175, "DB", "Dâmbovita"),
	(3180, 175, "DJ", "Dolj"),
	(3181, 175, "GJ", "Gorj"),
	(3182, 175, "GL", "Galati"),
	(3183, 175, "GR", "Giurgiu"),
	(3184, 175, "HD", "Hunedoara"),
	(3185, 175, "HR", "Harghita"),
	(3186, 175, "IF", "Ilfov"),
	(3187, 175, "IL", "Ialomita"),
	(3188, 175, "IS", "Iasi"),
	(3189, 175, "MH", "Mehedinti"),
	(3190, 175, "MM", "Maramures"),
	(3191, 175, "MS", "Mures"),
	(3192, 175, "NT", "Neamt"),
	(3193, 175, "OT", "Olt"),
	(3194, 175, "PH", "Prahova"),
	(3195, 175, "SB", "Sibiu"),
	(3196, 175, "SJ", "Salaj"),
	(3197, 175, "SM", "Satu Mare"),
	(3198, 175, "SV", "Suceava"),
	(3199, 175, "TL", "Tulcea"),
	(3200, 175, "TM", "Timis"),
	(3201, 175, "TR", "Teleorman"),
	(3202, 175, "VL", "Vâlcea"),
	(3203, 175, "VN", "Vrancea"),
	(3204, 175, "VS", "Vaslui"),
	(3205, 176, "AD", "Adygeya, Respublika"),
	(3206, 176, "AL", "Altay, Respublika"),
	(3207, 176, "ALT", "Altayskiy kray"),
	(3208, 176, "AMU", "Amurskaya oblast'"),
	(3209, 176, "ARK", "Arkhangel'skaya oblast'"),
	(3210, 176, "AST", "Astrakhanskaya oblast'"),
	(3211, 176, "BA", "Bashkortostan, Respublika"),
	(3212, 176, "BEL", "Belgorodskaya oblast'"),
	(3213, 176, "BRY", "Bryanskaya oblast'"),
	(3214, 176, "BU", "Buryatiya, Respublika"),
	(3215, 176, "CE", "Chechenskaya Respublika"),
	(3216, 176, "CHE", "Chelyabinskaya oblast'"),
	(3217, 176, "CHU", "Chukotskiy avtonomnyy okrug"),
	(3218, 176, "CU", "Chuvashskaya Respublika"),
	(3219, 176, "DA", "Dagestan, Respublika"),
	(3220, 176, "IN", "Ingushskaya Respublika [Respublika Ingushetiya]"),
	(3221, 176, "IRK", "Irkutskaya oblast'"),
	(3222, 176, "IVA", "Ivanovskaya oblast'"),
	(3223, 176, "KAM", "Kamchatskaya oblast'"),
	(3224, 176, "KB", "Kabardino-Balkarskaya Respublika"),
	(3225, 176, "KC", "Karachayevo-Cherkesskaya Respublika"),
	(3226, 176, "KDA", "Krasnodarskiy kray"),
	(3227, 176, "KEM", "Kemerovskaya oblast'"),
	(3228, 176, "KGD", "Kaliningradskaya oblast'"),
	(3229, 176, "KGN", "Kurganskaya oblast'"),
	(3230, 176, "KHA", "Khabarovskiy kray"),
	(3231, 176, "KHM", "Khanty-Mansiyskiy avtonomnyy okrug [Yugra]"),
	(3232, 176, "KIR", "Kirovskaya oblast'"),
	(3233, 176, "KK", "Khakasiya, Respublika"),
	(3234, 176, "KL", "Kalmykiya, Respublika"),
	(3235, 176, "KLU", "Kaluzhskaya oblast'"),
	(3236, 176, "KO", "Komi, Respublika"),
	(3237, 176, "KOS", "Kostromskaya oblast'"),
	(3238, 176, "KR", "Kareliya, Respublika"),
	(3239, 176, "KRS", "Kurskaya oblast'"),
	(3240, 176, "KYA", "Krasnoyarskiy kray"),
	(3241, 176, "LEN", "Leningradskaya oblast'"),
	(3242, 176, "LIP", "Lipetskaya oblast'"),
	(3243, 176, "MAG", "Magadanskaya oblast'"),
	(3244, 176, "ME", "Mariy El, Respublika"),
	(3245, 176, "MO", "Mordoviya, Respublika"),
	(3246, 176, "MOS", "Moskovskaya oblast'"),
	(3247, 176, "MOW", "Moskva"),
	(3248, 176, "MUR", "Murmanskaya oblast'"),
	(3249, 176, "NEN", "Nenetskiy avtonomnyy okrug"),
	(3250, 176, "NGR", "Novgorodskaya oblast'"),
	(3251, 176, "NIZ", "Nizhegorodskaya oblast'"),
	(3252, 176, "NVS", "Novosibirskaya oblast'"),
	(3253, 176, "OMS", "Omskaya oblast'"),
	(3254, 176, "ORE", "Orenburgskaya oblast'"),
	(3255, 176, "ORL", "Orlovskaya oblast'"),
	(3256, 176, "PER", "Perm"),
	(3257, 176, "PNZ", "Penzenskaya oblast'"),
	(3258, 176, "PRI", "Primorskiy kray"),
	(3259, 176, "PSK", "Pskovskaya oblast'"),
	(3260, 176, "ROS", "Rostovskaya oblast'"),
	(3261, 176, "RYA", "Ryazanskaya oblast'"),
	(3262, 176, "SA", "Sakha, Respublika [Yakutiya]"),
	(3263, 176, "SAK", "Sakhalinskaya oblast'"),
	(3264, 176, "SAM", "Samarskaya oblast'"),
	(3265, 176, "SAR", "Saratovskaya oblast'"),
	(3266, 176, "SE", "Severnaya Osetiya, Respublika [Alaniya] [Respublika Severnaya Osetiya-Alaniya]"),
	(3267, 176, "SMO", "Smolenskaya oblast'"),
	(3268, 176, "SPE", "Sankt-Peterburg"),
	(3269, 176, "STA", "Stavropol'skiy kray"),
	(3270, 176, "SVE", "Sverdlovskaya oblast'"),
	(3271, 176, "TA", "Tatarstan, Respublika"),
	(3272, 176, "TAM", "Tambovskaya oblast'"),
	(3273, 176, "TOM", "Tomskaya oblast'"),
	(3274, 176, "TUL", "Tul'skaya oblast'"),
	(3275, 176, "TVE", "Tverskaya oblast'"),
	(3276, 176, "TY", "Tyva, Respublika [Tuva]"),
	(3277, 176, "TYU", "Tyumenskaya oblast'"),
	(3278, 176, "UD", "Udmurtskaya Respublika"),
	(3279, 176, "ULY", "Ul'yanovskaya oblast'"),
	(3280, 176, "VGG", "Volgogradskaya oblast'"),
	(3281, 176, "VLA", "Vladimirskaya oblast'"),
	(3282, 176, "VLG", "Vologodskaya oblast'"),
	(3283, 176, "VOR", "Voronezhskaya oblast'"),
	(3284, 176, "X1~", "Komi-Permyak"),
	(3285, 176, "YAN", "Yamalo-Nenetskiy avtonomnyy okrug"),
	(3286, 176, "YAR", "Yaroslavskaya oblast'"),
	(3287, 176, "YEV", "Yevreyskaya avtonomnaya oblast'"),
	(3288, 176, "ZAB", "Zabajkal'skij kraj"),
	(3289, 177, "01", "Ville de Kigali"),
	(3290, 177, "02", "Est"),
	(3291, 177, "03", "Nord"),
	(3292, 177, "04", "Ouest"),
	(3293, 177, "05", "Sud"),
	(3294, 178, "01", "Christ Church Nichola Town"),
	(3295, 178, "02", "Saint Anne Sandy Point"),
	(3296, 178, "03", "Saint George Basseterre"),
	(3297, 178, "04", "Saint George Gingerland"),
	(3298, 178, "05", "Saint James Windward"),
	(3299, 178, "06", "Saint John Capisterre"),
	(3300, 178, "07", "Saint John Figtree"),
	(3301, 178, "08", "Saint Mary Cayon"),
	(3302, 178, "09", "Saint Paul Capisterre"),
	(3303, 178, "10", "Saint Paul Charlestown"),
	(3304, 178, "11", "Saint Peter Basseterre"),
	(3305, 178, "12", "Saint Thomas Lowland"),
	(3306, 178, "13", "Saint Thomas Middle Island"),
	(3307, 178, "15", "Trinity Palmetto Point"),
	(3308, 178, "K", "Saint Kitts"),
	(3309, 178, "N", "Nevis"),
	(3310, 179, "01", "Anse-la-Raye"),
	(3311, 179, "02", "Castries"),
	(3312, 179, "03", "Choiseul"),
	(3313, 179, "04", "Dauphin"),
	(3314, 179, "05", "Dennery"),
	(3315, 179, "06", "Gros Inlet"),
	(3316, 179, "07", "Laborie"),
	(3317, 179, "08", "Micoud"),
	(3318, 179, "09", "Praslin"),
	(3319, 179, "10", "Soufrière"),
	(3320, 179, "11", "Vieux Fort"),
	(3321, 180, "01", "Charlotte"),
	(3322, 180, "02", "Saint Andrew"),
	(3323, 180, "03", "Saint David"),
	(3324, 180, "04", "Saint George"),
	(3325, 180, "05", "Saint Patrick"),
	(3326, 180, "06", "Grenadines"),
	(3327, 181, "AA", "A'ana"),
	(3328, 181, "AL", "Aiga-i-le-Tai"),
	(3329, 181, "AT", "Atua"),
	(3330, 181, "FA", "Fa'asaleleaga"),
	(3331, 181, "GE", "Gaga'emauga"),
	(3332, 181, "GI", "Gagaifomauga"),
	(3333, 181, "PA", "Palauli"),
	(3334, 181, "SA", "Satupa'itea"),
	(3335, 181, "TU", "Tuamasaga"),
	(3336, 181, "VF", "Va'a-o-Fonoti"),
	(3337, 181, "VS", "Vaisigano"),
	(3338, 182, "01", "Acquaviva"),
	(3339, 182, "02", "Chiesanuova"),
	(3340, 182, "03", "Domagnano"),
	(3341, 182, "04", "Faetano"),
	(3342, 182, "05", "Fiorentino"),
	(3343, 182, "06", "Borgo Maggiore"),
	(3344, 182, "07", "San Marino"),
	(3345, 182, "08", "Montegiardino"),
	(3346, 182, "09", "Serravalle"),
	(3347, 183, "P", "Príncipe"),
	(3348, 183, "S", "São Tomé"),
	(3349, 184, "01", "Ar Riyāḑ"),
	(3350, 184, "02", "Makkah"),
	(3351, 184, "03", "Al Madinah"),
	(3352, 184, "04", "Ash Sharqiyah"),
	(3353, 184, "05", "Al Qasim"),
	(3354, 184, "06", "Ha'il"),
	(3355, 184, "07", "Tabuk"),
	(3356, 184, "08", "Al Ḩudūd ash Shamālīyah"),
	(3357, 184, "09", "Jizan"),
	(3358, 184, "10", "Najran"),
	(3359, 184, "11", "Al Bāḩah"),
	(3360, 184, "12", "Al Jawf"),
	(3361, 184, "14", "Asir"),
	(3362, 185, "DB", "Diourbel"),
	(3363, 185, "DK", "Dakar"),
	(3364, 185, "FK", "Fatick"),
	(3365, 185, "KA", "Kaffrine"),
	(3366, 185, "KD", "Kolda"),
	(3367, 185, "KE", "Kédougou"),
	(3368, 185, "KL", "Kaolack"),
	(3369, 185, "LG", "Louga"),
	(3370, 185, "MT", "Matam"),
	(3371, 185, "SE", "Sédhiou"),
	(3372, 185, "SL", "Saint-Louis"),
	(3373, 185, "TC", "Tambacounda"),
	(3374, 185, "TH", "Thiès"),
	(3375, 185, "ZG", "Ziguinchor"),
	(3376, 186, "01", "Anse aux Pins"),
	(3377, 186, "02", "Anse Boileau"),
	(3378, 186, "03", "Anse Étoile"),
	(3379, 186, "04", "Au Cap"),
	(3380, 186, "05", "Anse Royale"),
	(3381, 186, "06", "Baie Lazare"),
	(3382, 186, "07", "Baie Sainte Anne"),
	(3383, 186, "08", "Beau Vallon"),
	(3384, 186, "09", "Bel Air"),
	(3385, 186, "10", "Bel Ombre"),
	(3386, 186, "11", "Cascade"),
	(3387, 186, "12", "Glacis"),
	(3388, 186, "13", "Grand Anse Mahe"),
	(3389, 186, "14", "Grand Anse Praslin"),
	(3390, 186, "15", "La Digue"),
	(3391, 186, "16", "English River"),
	(3392, 186, "17", "Mont Buxton"),
	(3393, 186, "18", "Mont Fleuri"),
	(3394, 186, "19", "Plaisance"),
	(3395, 186, "20", "Pointe La Rue"),
	(3396, 186, "21", "Port Glaud"),
	(3397, 186, "22", "Saint Louis"),
	(3398, 186, "23", "Takamaka"),
	(3399, 186, "24", "Les Mamelles"),
	(3400, 186, "25", "Roche Caiman"),
	(3401, 187, "E", "Eastern"),
	(3402, 187, "N", "Northern"),
	(3403, 187, "S", "Southern"),
	(3404, 187, "W", "Western Area (Freetown)"),
	(3405, 188, "01", "Central Singapore"),
	(3406, 188, "02", "North East"),
	(3407, 188, "03", "North West"),
	(3408, 188, "04", "South East"),
	(3409, 188, "05", "South West"),
	(3410, 188, "X1~", "Singapore - No State"),
	(3411, 189, "BC", "Banskobystrický kraj"),
	(3412, 189, "BL", "Bratislavský kraj"),
	(3413, 189, "KI", "Košický kraj"),
	(3414, 189, "NI", "Nitriansky kraj"),
	(3415, 189, "PV", "Prešovský kraj"),
	(3416, 189, "TA", "Trnavský kraj"),
	(3417, 189, "TC", "Trenciansky kraj"),
	(3418, 189, "ZI", "Žilinský kraj"),
	(3419, 190, "001", "Ajdovšcina"),
	(3420, 190, "002", "Beltinci"),
	(3421, 190, "003", "Bled"),
	(3422, 190, "004", "Bohinj"),
	(3423, 190, "005", "Borovnica"),
	(3424, 190, "006", "Bovec"),
	(3425, 190, "007", "Brda"),
	(3426, 190, "008", "Brezovica"),
	(3427, 190, "009", "Brežice"),
	(3428, 190, "010", "Tišina"),
	(3429, 190, "011", "Celje"),
	(3430, 190, "012", "Cerklje na Gorenjskem"),
	(3431, 190, "013", "Cerknica"),
	(3432, 190, "014", "Cerkno"),
	(3433, 190, "015", "Crenšovci"),
	(3434, 190, "016", "Crna na Koroškem"),
	(3435, 190, "017", "Crnomelj"),
	(3436, 190, "018", "Destrnik"),
	(3437, 190, "019", "Divaca"),
	(3438, 190, "020", "Dobrepolje"),
	(3439, 190, "021", "Dobrova-Polhov Gradec"),
	(3440, 190, "022", "Dol pri Ljubljani"),
	(3441, 190, "023", "Domžale"),
	(3442, 190, "024", "Dornava"),
	(3443, 190, "025", "Dravograd"),
	(3444, 190, "026", "Duplek"),
	(3445, 190, "027", "Gorenja vas-Poljane"),
	(3446, 190, "028", "Gorišnica"),
	(3447, 190, "029", "Gornja Radgona"),
	(3448, 190, "030", "Gornji Grad"),
	(3449, 190, "031", "Gornji Petrovci"),
	(3450, 190, "032", "Grosuplje"),
	(3451, 190, "033", "Šalovci"),
	(3452, 190, "034", "Hrastnik"),
	(3453, 190, "035", "Hrpelje-Kozina"),
	(3454, 190, "036", "Idrija"),
	(3455, 190, "037", "Ig"),
	(3456, 190, "038", "Ilirska Bistrica"),
	(3457, 190, "039", "Ivancna Gorica"),
	(3458, 190, "040", "Izola/Isola"),
	(3459, 190, "041", "Jesenice"),
	(3460, 190, "042", "Juršinci"),
	(3461, 190, "043", "Kamnik"),
	(3462, 190, "044", "Kanal"),
	(3463, 190, "045", "Kidricevo"),
	(3464, 190, "046", "Kobarid"),
	(3465, 190, "047", "Kobilje"),
	(3466, 190, "048", "Kocevje"),
	(3467, 190, "049", "Komen"),
	(3468, 190, "050", "Koper/Capodistria"),
	(3469, 190, "051", "Kozje"),
	(3470, 190, "052", "Kranj"),
	(3471, 190, "053", "Kranjska Gora"),
	(3472, 190, "054", "Krško"),
	(3473, 190, "055", "Kungota"),
	(3474, 190, "056", "Kuzma"),
	(3475, 190, "057", "Laško"),
	(3476, 190, "058", "Lenart"),
	(3477, 190, "059", "Lendava/Lendva"),
	(3478, 190, "060", "Litija"),
	(3479, 190, "061", "Ljubljana"),
	(3480, 190, "062", "Ljubno"),
	(3481, 190, "063", "Ljutomer"),
	(3482, 190, "064", "Logatec"),
	(3483, 190, "065", "Loška dolina"),
	(3484, 190, "066", "Loški Potok"),
	(3485, 190, "067", "Luce"),
	(3486, 190, "068", "Lukovica"),
	(3487, 190, "069", "Majšperk"),
	(3488, 190, "070", "Maribor"),
	(3489, 190, "071", "Medvode"),
	(3490, 190, "072", "Mengeš"),
	(3491, 190, "073", "Metlika"),
	(3492, 190, "074", "Mežica"),
	(3493, 190, "075", "Miren-Kostanjevica"),
	(3494, 190, "076", "Mislinja"),
	(3495, 190, "077", "Moravce"),
	(3496, 190, "078", "Moravske Toplice"),
	(3497, 190, "079", "Mozirje"),
	(3498, 190, "080", "Murska Sobota"),
	(3499, 190, "081", "Muta"),
	(3500, 190, "082", "Naklo"),
	(3501, 190, "083", "Nazarje"),
	(3502, 190, "084", "Nova Gorica"),
	(3503, 190, "085", "Novo mesto"),
	(3504, 190, "086", "Odranci"),
	(3505, 190, "087", "Ormož"),
	(3506, 190, "088", "Osilnica"),
	(3507, 190, "089", "Pesnica"),
	(3508, 190, "090", "Piran/Pirano"),
	(3509, 190, "091", "Pivka"),
	(3510, 190, "092", "Podcetrtek"),
	(3511, 190, "093", "Podvelka"),
	(3512, 190, "094", "Postojna"),
	(3513, 190, "095", "Preddvor"),
	(3514, 190, "096", "Ptuj"),
	(3515, 190, "097", "Puconci"),
	(3516, 190, "098", "Race-Fram"),
	(3517, 190, "099", "Radece"),
	(3518, 190, "100", "Radenci"),
	(3519, 190, "101", "Radlje ob Dravi"),
	(3520, 190, "102", "Radovljica"),
	(3521, 190, "103", "Ravne na Koroškem"),
	(3522, 190, "104", "Ribnica"),
	(3523, 190, "105", "Rogašovci"),
	(3524, 190, "106", "Rogaška Slatina"),
	(3525, 190, "107", "Rogatec"),
	(3526, 190, "108", "Ruše"),
	(3527, 190, "109", "Semic"),
	(3528, 190, "110", "Sevnica"),
	(3529, 190, "111", "Sežana"),
	(3530, 190, "112", "Slovenj Gradec"),
	(3531, 190, "113", "Slovenska Bistrica"),
	(3532, 190, "114", "Slovenske Konjice"),
	(3533, 190, "115", "Starše"),
	(3534, 190, "116", "Sveti Jurij"),
	(3535, 190, "117", "Šencur"),
	(3536, 190, "118", "Šentilj"),
	(3537, 190, "119", "Šentjernej"),
	(3538, 190, "120", "Šentjur pri Celju"),
	(3539, 190, "121", "Škocjan"),
	(3540, 190, "122", "Škofja Loka"),
	(3541, 190, "123", "Škofljica"),
	(3542, 190, "124", "Šmarje pri Jelšah"),
	(3543, 190, "125", "Šmartno ob Paki"),
	(3544, 190, "126", "Šoštanj"),
	(3545, 190, "127", "Štore"),
	(3546, 190, "128", "Tolmin"),
	(3547, 190, "129", "Trbovlje"),
	(3548, 190, "130", "Trebnje"),
	(3549, 190, "131", "Tržic"),
	(3550, 190, "132", "Turnišce"),
	(3551, 190, "133", "Velenje"),
	(3552, 190, "134", "Velike Lašce"),
	(3553, 190, "135", "Videm"),
	(3554, 190, "136", "Vipava"),
	(3555, 190, "137", "Vitanje"),
	(3556, 190, "138", "Vodice"),
	(3557, 190, "139", "Vojnik"),
	(3558, 190, "140", "Vrhnika"),
	(3559, 190, "141", "Vuzenica"),
	(3560, 190, "142", "Zagorje ob Savi"),
	(3561, 190, "143", "Zavrc"),
	(3562, 190, "144", "Zrece"),
	(3563, 190, "146", "Železniki"),
	(3564, 190, "147", "Žiri"),
	(3565, 190, "148", "Benedikt"),
	(3566, 190, "149", "Bistrica ob Sotli"),
	(3567, 190, "150", "Bloke"),
	(3568, 190, "151", "Braslovce"),
	(3569, 190, "152", "Cankova"),
	(3570, 190, "153", "Cerkvenjak"),
	(3571, 190, "154", "Dobje"),
	(3572, 190, "155", "Dobrna"),
	(3573, 190, "156", "Dobrovnik/Dobronak"),
	(3574, 190, "157", "Dolenjske Toplice"),
	(3575, 190, "158", "Grad"),
	(3576, 190, "159", "Hajdina"),
	(3577, 190, "160", "Hoce-Slivnica"),
	(3578, 190, "161", "Hodoš/Hodos"),
	(3579, 190, "162", "Horjul"),
	(3580, 190, "163", "Jezersko"),
	(3581, 190, "164", "Komenda"),
	(3582, 190, "165", "Kostel"),
	(3583, 190, "166", "Križevci"),
	(3584, 190, "167", "Lovrenc na Pohorju"),
	(3585, 190, "168", "Markovci"),
	(3586, 190, "169", "Miklavž na Dravskem polju"),
	(3587, 190, "170", "Mirna Pec"),
	(3588, 190, "171", "Oplotnica"),
	(3589, 190, "172", "Podlehnik"),
	(3590, 190, "173", "Polzela"),
	(3591, 190, "174", "Prebold"),
	(3592, 190, "175", "Prevalje"),
	(3593, 190, "176", "Razkrižje"),
	(3594, 190, "177", "Ribnica na Pohorju"),
	(3595, 190, "178", "Selnica ob Dravi"),
	(3596, 190, "179", "Sodražica"),
	(3597, 190, "180", "Solcava"),
	(3598, 190, "181", "Sveta Ana"),
	(3599, 190, "182", "Sveti Andraž v Slovenskih goricah"),
	(3600, 190, "183", "Šempeter-Vrtojba"),
	(3601, 190, "184", "Tabor"),
	(3602, 190, "185", "Trnovska vas"),
	(3603, 190, "186", "Trzin"),
	(3604, 190, "187", "Velika Polana"),
	(3605, 190, "188", "Veržej"),
	(3606, 190, "189", "Vransko"),
	(3607, 190, "190", "Žalec"),
	(3608, 190, "191", "Žetale"),
	(3609, 190, "192", "Žirovnica"),
	(3610, 190, "193", "Žužemberk"),
	(3611, 190, "194", "Šmartno pri Litiji"),
	(3612, 190, "195", "Apače"),
	(3613, 190, "196", "Kosanjevica na Krki"),
	(3614, 190, "197", "Cirkulane"),
	(3615, 190, "198", "Makole"),
	(3616, 190, "199", "Mokronog-Trebelno"),
	(3617, 190, "200", "Poljčane"),
	(3618, 190, "201", "Renče-Vogrsko"),
	(3619, 190, "202", "Središče ob Dravi"),
	(3620, 190, "203", "Straža"),
	(3621, 190, "204", "Sveta Trojica v Slovenskih Goricah"),
	(3622, 190, "205", "Sveti Tomaž"),
	(3623, 190, "206", "Šmarješke Toplice"),
	(3624, 190, "207", "Gorje"),
	(3625, 190, "208", "Log-Dragomer"),
	(3626, 190, "209", "Rečica ob Savinji"),
	(3627, 190, "210", "Sveti Jurij v Slovenskih Goricah"),
	(3628, 190, "211", "Šentrupert"),
	(3629, 191, "CE", "Central"),
	(3630, 191, "CH", "Choiseul"),
	(3631, 191, "CT", "Capital Territory (Honiara)"),
	(3632, 191, "GU", "Guadalcanal"),
	(3633, 191, "IS", "Isabel"),
	(3634, 191, "MK", "Makira"),
	(3635, 191, "ML", "Malaita"),
	(3636, 191, "RB", "Rennell and Bellona"),
	(3637, 191, "TE", "Temotu"),
	(3638, 191, "WE", "Western"),
	(3639, 192, "AW", "Awdal"),
	(3640, 192, "BK", "Bakool"),
	(3641, 192, "BN", "Banaadir"),
	(3642, 192, "BR", "Bari"),
	(3643, 192, "BY", "Bay"),
	(3644, 192, "GA", "Galguduud"),
	(3645, 192, "GE", "Gedo"),
	(3646, 192, "HI", "Hiiraan"),
	(3647, 192, "JD", "Jubbada Dhexe"),
	(3648, 192, "JH", "Jubbada Hoose"),
	(3649, 192, "MU", "Mudug"),
	(3650, 192, "NU", "Nugaal"),
	(3651, 192, "SA", "Sanaag"),
	(3652, 192, "SD", "Shabeellaha Dhexe"),
	(3653, 192, "SH", "Shabeellaha Hoose"),
	(3654, 192, "SO", "Sool"),
	(3655, 192, "TO", "Togdheer"),
	(3656, 192, "WO", "Woqooyi Galbeed"),
	(3657, 193, "EC", "Eastern Cape"),
	(3658, 193, "FS", "Free State"),
	(3659, 193, "GT", "Gauteng"),
	(3660, 193, "MP", "Mpumalanga"),
	(3661, 193, "NC", "Northern Cape"),
	(3662, 193, "NL", "Kwazulu-Natal"),
	(3663, 193, "NP", "Limpodo"),
	(3664, 193, "NW", "North-West"),
	(3665, 193, "WC", "Western Cape"),
	(3666, 195, "A", "Alicante"),
	(3667, 195, "AB", "Albacete"),
	(3668, 195, "AL", "Almería"),
	(3670, 195, "AN", "Andalucía"),
	(3671, 195, "AS", "Asturias, Principado de"),
	(3672, 195, "AV", "Ávila"),
	(3674, 195, "B", "Barcelona"),
	(3675, 195, "BA", "Badajoz"),
	(3676, 195, "BI", "Vizcaya"),
	(3677, 195, "BU", "Burgos"),
	(3678, 195, "C", "A Coruña"),
	(3679, 195, "CA", "Cádiz"),
	(3681, 195, "CB", "Cantabria"),
	(3682, 195, "CC", "Cáceres"),
	(3683, 195, "CE", "Ceuta"),
	(3684, 195, "CL", "Castilla y León"),
	(3685, 195, "CM", "Castilla-La Mancha"),
	(3686, 195, "CN", "Canarias"),
	(3687, 195, "CO", "Córdoba"),
	(3688, 195, "CR", "Ciudad Real"),
	(3689, 195, "CS", "Castellón"),
	(3690, 195, "CT", "Catalunya"),
	(3691, 195, "CU", "Cuenca"),
	(3692, 195, "EX", "Extremadura"),
	(3693, 195, "GA", "Galicia"),
	(3694, 195, "GC", "Las Palmas"),
	(3695, 195, "GI", "Girona"),
	(3696, 195, "GR", "Granada"),
	(3697, 195, "GU", "Guadalajara"),
	(3698, 195, "H", "Huelva"),
	(3699, 195, "HU", "Huesca"),
	(3700, 195, "IB", "Illes Balears"),
	(3701, 195, "J", "Jaén"),
	(3702, 195, "L", "Lleida"),
	(3703, 195, "LE", "León"),
	(3704, 195, "LO", "La Rioja"),
	(3705, 195, "LU", "Lugo"),
	(3706, 195, "M", "Madrid"),
	(3707, 195, "MA", "Málaga"),
	(3708, 195, "MC", "Murcia, Región de"),
	(3709, 195, "MD", "Madrid, Comunidad de"),
	(3710, 195, "ML", "Melilla"),
	(3711, 195, "MU", "Murcia"),
	(3712, 195, "NA", "Navarra"),
	(3713, 195, "NC", "Navarra, Comunidad Foral de"),
	(3714, 195, "O", "Asturias"),
	(3715, 195, "OR", "Ourense"),
	(3716, 195, "P", "Palencia"),
	(3717, 195, "PM", "Baleares"),
	(3718, 195, "PO", "Pontevedra"),
	(3719, 195, "PV", "País Vasco"),
	(3720, 195, "SA", "Salamanca"),
	(3721, 195, "SE", "Sevilla"),
	(3722, 195, "SG", "Segovia"),
	(3723, 195, "SO", "Soria"),
	(3724, 195, "SS", "Guipúzcoa"),
	(3725, 195, "T", "Tarragona"),
	(3726, 195, "TE", "Teruel"),
	(3727, 195, "TF", "Santa Cruz de Tenerife"),
	(3728, 195, "TO", "Toledo"),
	(3729, 195, "V", "Valencia"),
	(3730, 195, "VA", "Valladolid"),
	(3731, 195, "VC", "Valenciana, Comunidad"),
	(3732, 195, "VI", "Álava"),
	(3733, 195, "Z", "Zaragoza"),
	(3734, 195, "ZA", "Zamora"),
	(3735, 196, "1", "Basnāhira paḷāta"),
	(3736, 196, "11", "Kŏḷamba"),
	(3737, 196, "12", "Gampaha"),
	(3738, 196, "13", "Kalutara"),
	(3739, 196, "2", "Madhyama paḷāta"),
	(3740, 196, "21", "Mahanuvara"),
	(3741, 196, "22", "Mātale"),
	(3742, 196, "23", "Nuvara Ĕliya"),
	(3743, 196, "3", "Dakuṇu paḷāta"),
	(3744, 196, "31", "Gālla"),
	(3745, 196, "32", "Mātara"),
	(3746, 196, "33", "Hambantŏṭa"),
	(3747, 196, "4", "Uturu paḷāta"),
	(3748, 196, "41", "Yāpanaya"),
	(3749, 196, "42", "Kilinŏchchi"),
	(3750, 196, "43", "Mannārama"),
	(3751, 196, "44", "Vavuniyāva"),
	(3752, 196, "45", "Mulativ"),
	(3753, 196, "5", "Mattiya mākāṇam"),
	(3754, 196, "51", "Madakalapuva"),
	(3755, 196, "52", "Ampāra"),
	(3756, 196, "53", "Trikuṇāmalaya"),
	(3757, 196, "6", "Vayamba paḷāta"),
	(3758, 196, "61", "Kuruṇægala"),
	(3759, 196, "62", "Puttalama"),
	(3760, 196, "7", "Uturumæ̆da paḷāta"),
	(3761, 196, "71", "Anurādhapura"),
	(3762, 196, "72", "Pŏḷŏnnaruva"),
	(3763, 196, "8", "Ūva paḷāta"),
	(3764, 196, "81", "Badulla"),
	(3765, 196, "82", "Mŏṇarāgala"),
	(3766, 196, "9", "Sabaragamuva paḷāta"),
	(3767, 196, "91", "Ratnapura"),
	(3768, 196, "92", "Kegalla"),
	(3769, 197, "AC", "Ascension"),
	(3770, 197, "HL", "Saint Helena"),
	(3771, 197, "SH", "Saint Helena"),
	(3772, 197, "TA", "Tristan da Cunha"),
	(3773, 199, "10", "Gharb Kurdufan"),
	(3774, 199, "DC", "Zalingei"),
	(3775, 199, "DE", "Sharq Dārfūr"),
	(3776, 199, "DN", "Shamal Darfur"),
	(3777, 199, "DS", "Janub Darfur"),
	(3778, 199, "DW", "Gharb Darfur"),
	(3779, 199, "GD", "Al Qaḑārif"),
	(3780, 199, "GZ", "Al Jazirah"),
	(3781, 199, "KA", "Kassala"),
	(3782, 199, "KH", "Al Khartum"),
	(3783, 199, "KN", "Shamal Kurdufan"),
	(3784, 199, "KS", "Janub Kurdufan"),
	(3785, 199, "NB", "An Nil al Azraq"),
	(3786, 199, "NO", "Ash Shamaliyah"),
	(3787, 199, "NR", "An Nil"),
	(3788, 199, "NW", "An Nīl al Abyaḑ"),
	(3789, 199, "RS", "Al Bah¸r al Ah¸mar"),
	(3790, 199, "SI", "Sinnar"),
	(3791, 200, "BR", "Brokopondo"),
	(3792, 200, "CM", "Commewijne"),
	(3793, 200, "CR", "Coronie"),
	(3794, 200, "MA", "Marowijne"),
	(3795, 200, "NI", "Nickerie"),
	(3796, 200, "PM", "Paramaribo"),
	(3797, 200, "PR", "Para"),
	(3798, 200, "SA", "Saramacca"),
	(3799, 200, "SI", "Sipaliwini"),
	(3800, 200, "WA", "Wanica"),
	(3801, 202, "HH", "Hhohho"),
	(3802, 202, "LU", "Lubombo"),
	(3803, 202, "MA", "Manzini"),
	(3804, 202, "SH", "Shiselweni"),
	(3805, 203, "AB", "Stockholms län"),
	(3806, 203, "AC", "Västerbottens län"),
	(3807, 203, "BD", "Norrbottens län"),
	(3808, 203, "C", "Uppsala län"),
	(3809, 203, "D", "Södermanlands län"),
	(3810, 203, "E", "Östergötlands län"),
	(3811, 203, "F", "Jönköpings län"),
	(3812, 203, "G", "Kronobergs län"),
	(3813, 203, "H", "Kalmar län"),
	(3814, 203, "I", "Gotlands län"),
	(3815, 203, "K", "Blekinge län"),
	(3816, 203, "M", "Skåne län"),
	(3817, 203, "N", "Hallands län"),
	(3818, 203, "O", "Västra Götalands län"),
	(3819, 203, "S", "Värmlands län"),
	(3820, 203, "T", "Örebro län"),
	(3821, 203, "U", "Västmanlands län"),
	(3822, 203, "W", "Dalarnas län"),
	(3823, 203, "X", "Gävleborgs län"),
	(3824, 203, "Y", "Västernorrlands län"),
	(3825, 203, "Z", "Jämtlands län"),
	(3826, 204, "AG", "Aargau"),
	(3827, 204, "AI", "Appenzell Innerrhoden"),
	(3828, 204, "AR", "Appenzell Ausserrhoden"),
	(3829, 204, "BE", "Bern"),
	(3830, 204, "BL", "Basel-Landschaft"),
	(3831, 204, "BS", "Basel-Stadt"),
	(3832, 204, "FR", "Freiburg"),
	(3833, 204, "GE", "Genf"),
	(3834, 204, "GL", "Glarus"),
	(3835, 204, "GR", "Graubünden"),
	(3836, 204, "JU", "Jura"),
	(3837, 204, "LU", "Luzern"),
	(3838, 204, "NE", "Neuenburg"),
	(3839, 204, "NW", "Nidwalden"),
	(3840, 204, "OW", "Obwalden"),
	(3841, 204, "SG", "St. Gallen"),
	(3842, 204, "SH", "Schaffhausen"),
	(3843, 204, "SO", "Solothurn"),
	(3844, 204, "SZ", "Schwyz"),
	(3845, 204, "TG", "Thurgau"),
	(3846, 204, "TI", "Tessin"),
	(3847, 204, "UR", "Uri"),
	(3848, 204, "VD", "Waadt"),
	(3849, 204, "VS", "Wallis"),
	(3850, 204, "ZG", "Zug"),
	(3851, 204, "ZH", "Zürich"),
	(3852, 205, "DI", "Dimashq"),
	(3853, 205, "DR", "Dar'a"),
	(3854, 205, "DY", "Dayr az Zawr"),
	(3855, 205, "HA", "Al-Hasaka"),
	(3856, 205, "HI", "Homs"),
	(3857, 205, "HL", "Halab"),
	(3858, 205, "HM", "Hamah"),
	(3859, 205, "ID", "Idlib"),
	(3860, 205, "LA", "Al Ladhiqiyah"),
	(3861, 205, "QU", "Al Qunaytirah"),
	(3862, 205, "RA", "Ar Raqqah"),
	(3863, 205, "RD", "Rif Dimashq"),
	(3864, 205, "SU", "As Suwayda'"),
	(3865, 205, "TA", "Tartus"),
	(3866, 206, "CHA", "Changhua"),
	(3867, 206, "CYI", "Chiayi Municipality"),
	(3868, 206, "CYQ", "Chiayi"),
	(3869, 206, "HSQ", "Hsinchu"),
	(3870, 206, "HSZ", "Hsinchu Municipality"),
	(3871, 206, "HUA", "Hualien"),
	(3872, 206, "ILA", "Ilan"),
	(3873, 206, "KEE", "Keelung Municipality"),
	(3874, 206, "KHH", "Kaohsiung Special Municipality"),
	(3875, 206, "KHQ", "Kaohsiung"),
	(3876, 206, "MIA", "Miaoli"),
	(3877, 206, "NAN", "Nantou"),
	(3878, 206, "PEN", "Penghu"),
	(3879, 206, "PIF", "Pingtung"),
	(3880, 206, "TAO", "Taoyuan"),
	(3881, 206, "TNN", "Tainan Municipality"),
	(3882, 206, "TNQ", "Tainan"),
	(3883, 206, "TPE", "Taipei Special Municipality"),
	(3884, 206, "TPQ", "Taipei"),
	(3885, 206, "TTT", "Taitung"),
	(3886, 206, "TXG", "Taichung Municipality"),
	(3887, 206, "TXQ", "Taichung"),
	(3888, 206, "YUN", "Yunlin"),
	(3889, 207, "DU", "Dushanbe"),
	(3890, 207, "GB", "Gorno-Badakhshan"),
	(3891, 207, "KT", "Khatlon"),
	(3892, 207, "SU", "Sughd"),
	(3893, 208, "01", "Arusha"),
	(3894, 208, "02", "Dar es Salaam"),
	(3895, 208, "03", "Dodoma"),
	(3896, 208, "04", "Iringa"),
	(3897, 208, "05", "Kagera"),
	(3898, 208, "06", "Kaskazini Pemba"),
	(3899, 208, "07", "Kaskazini Unguja"),
	(3900, 208, "08", "Kigoma"),
	(3901, 208, "09", "Kilimanjaro"),
	(3902, 208, "10", "Kusini Pemba"),
	(3903, 208, "11", "Kusini Unguja"),
	(3904, 208, "12", "Lindi"),
	(3905, 208, "13", "Mara"),
	(3906, 208, "14", "Mbeya"),
	(3907, 208, "15", "Mjini Magharibi"),
	(3908, 208, "16", "Morogoro"),
	(3909, 208, "17", "Mtwara"),
	(3910, 208, "18", "Mwanza"),
	(3911, 208, "19", "Pwani"),
	(3912, 208, "20", "Rukwa"),
	(3913, 208, "21", "Ruvuma"),
	(3914, 208, "22", "Shinyanga"),
	(3915, 208, "23", "Singida"),
	(3916, 208, "24", "Tabora"),
	(3917, 208, "25", "Tanga"),
	(3918, 208, "26", "Manyara"),
	(3919, 209, "ACR", "Amnat Charoen"),
	(3920, 209, "ATG", "Ang Thong"),
	(3921, 209, "AYA", "Phra Nakhon Si Ayutthaya"),
	(3922, 209, "BKK", "Bangkok (Krung Thep Maha Nakhon)"),
	(3923, 209, "BRM", "Buriram"),
	(3924, 209, "CBI", "Chonburi"),
	(3925, 209, "CCO", "Chachoengsao"),
	(3926, 209, "CMI", "Chiang Mai"),
	(3927, 209, "CNT", "Chainat"),
	(3928, 209, "CPM", "Chaiyaphum"),
	(3929, 209, "CPN", "Chumphon"),
	(3930, 209, "CRI", "Chiang Rai"),
	(3931, 209, "CTI", "Chanthaburi"),
	(3932, 209, "KBI", "Krabi"),
	(3933, 209, "KKN", "Khon Kaen"),
	(3934, 209, "KPT", "Kamphaeng Phet"),
	(3935, 209, "KRI", "Kanchanaburi"),
	(3936, 209, "KSN", "Kalasin"),
	(3937, 209, "LEI", "Loei Province"),
	(3938, 209, "LPG", "Lampang"),
	(3939, 209, "LPN", "Lamphun"),
	(3940, 209, "LRI", "Lopburi Province"),
	(3941, 209, "MDH", "Mukdahan"),
	(3942, 209, "MKM", "Maha Sarakham"),
	(3943, 209, "MSN", "Mae Hong Son"),
	(3944, 209, "NAN", "Nan"),
	(3945, 209, "NBI", "Nonthaburi"),
	(3946, 209, "NBP", "Nong Bua Lamphu"),
	(3947, 209, "NKI", "Nong Khai"),
	(3948, 209, "NMA", "Nakhon Ratchasima"),
	(3949, 209, "NPM", "Nakhon Phanom"),
	(3950, 209, "NPT", "Nakhon Pathom"),
	(3951, 209, "NRT", "Nakhon Si Thammarat Province"),
	(3952, 209, "NSN", "Nakhon Sawan"),
	(3953, 209, "NWT", "Narathiwat"),
	(3954, 209, "NYK", "Nakhon Nayok"),
	(3955, 209, "PBI", "Phetchaburi"),
	(3956, 209, "PCT", "Phichit"),
	(3957, 209, "PKN", "Prachuap Khiri Khan"),
	(3958, 209, "PKT", "Phuket"),
	(3959, 209, "PLG", "Phatthalung"),
	(3960, 209, "PLK", "Phitsanulok"),
	(3961, 209, "PNA", "Phang Nga"),
	(3962, 209, "PNB", "Phetchabun"),
	(3963, 209, "PRE", "Phrae"),
	(3964, 209, "PRI", "Prachinburi"),
	(3965, 209, "PTE", "Pathum Thani"),
	(3966, 209, "PTN", "Pattani"),
	(3967, 209, "PYO", "Phayao"),
	(3968, 209, "RBR", "Ratchaburi"),
	(3969, 209, "RET", "Roi Et"),
	(3970, 209, "RNG", "Ranong"),
	(3971, 209, "RYG", "Rayong"),
	(3972, 209, "SBR", "Sing Buri"),
	(3973, 209, "SKA", "Songkhla"),
	(3974, 209, "SKM", "Samut Songkhram"),
	(3975, 209, "SKN", "Samut Sakhon"),
	(3976, 209, "SKW", "Sa Kaeo"),
	(3977, 209, "SNI", "Surat Thani"),
	(3978, 209, "SNK", "Sakon Nakhon"),
	(3979, 209, "SPB", "Suphan Buri"),
	(3980, 209, "SPK", "Samut Prakan"),
	(3981, 209, "SRI", "Saraburi"),
	(3982, 209, "SRN", "Surin"),
	(3983, 209, "SSK", "Sisaket"),
	(3984, 209, "STI", "Sukhothai"),
	(3985, 209, "STN", "Satun"),
	(3986, 209, "TAK", "Tak"),
	(3987, 209, "TRG", "Trang"),
	(3988, 209, "TRT", "Trat"),
	(3989, 209, "UBN", "Ubon Ratchathani"),
	(3990, 209, "UDN", "Udon Thani"),
	(3991, 209, "UTD", "Uttaradit"),
	(3992, 209, "UTI", "Uthai Thani"),
	(3993, 209, "YLA", "Yala"),
	(3994, 209, "YST", "Yasothon"),
	(3995, 210, "C", "Centre"),
	(3996, 210, "K", "Kara"),
	(3997, 210, "M", "Maritime (Région)"),
	(3998, 210, "P", "Plateaux"),
	(3999, 210, "S", "Savannes"),
	(4000, 212, "01", "Eua Island"),
	(4001, 212, "02", "Ha'apai"),
	(4002, 212, "03", "Niuas"),
	(4003, 212, "04", "Tongatapu"),
	(4004, 212, "05", "Vava'u"),
	(4005, 213, "ARI", "Arima"),
	(4006, 213, "CHA", "Chaguanas"),
	(4007, 213, "CTT", "Couva-Tabaquite-Talparo"),
	(4008, 213, "DMN", "Diego Martin"),
	(4009, 213, "ETO", "Eastern Tobago"),
	(4010, 213, "PED", "Penal-Debe"),
	(4011, 213, "POS", "Port of Spain"),
	(4012, 213, "PRT", "Princes Town"),
	(4013, 213, "PTF", "Point Fortin"),
	(4014, 213, "RCM", "Rio Claro-Mayaro"),
	(4015, 213, "SFO", "San Fernando"),
	(4016, 213, "SGE", "Sangre Grande"),
	(4017, 213, "SIP", "Siparia"),
	(4018, 213, "SJL", "San Juan-Laventille"),
	(4019, 213, "TUP", "Tunapuna-Piarco"),
	(4020, 213, "WTO", "Western Tobago"),
	(4021, 214, "11", "Tunis"),
	(4022, 214, "12", "Ariana"),
	(4023, 214, "13", "Ben Arous"),
	(4024, 214, "14", "La Manouba"),
	(4025, 214, "21", "Nabeul"),
	(4026, 214, "22", "Zaghouan"),
	(4027, 214, "23", "Bizerte"),
	(4028, 214, "31", "Béja"),
	(4029, 214, "32", "Jendouba"),
	(4030, 214, "33", "Le Kef"),
	(4031, 214, "34", "Siliana"),
	(4032, 214, "41", "Kairouan"),
	(4033, 214, "42", "Kasserine"),
	(4034, 214, "43", "Sidi Bouzid"),
	(4035, 214, "51", "Sousse"),
	(4036, 214, "52", "Monastir"),
	(4037, 214, "53", "Mahdia"),
	(4038, 214, "61", "Sfax"),
	(4039, 214, "71", "Gafsa"),
	(4040, 214, "72", "Tozeur"),
	(4041, 214, "73", "Kebili"),
	(4042, 214, "81", "Gabès"),
	(4043, 214, "82", "Medenine"),
	(4044, 214, "83", "Tataouine"),
	(4045, 215, "01", "Adana"),
	(4046, 215, "02", "Adiyaman"),
	(4047, 215, "03", "Afyonkarahisar"),
	(4048, 215, "04", "Agri"),
	(4049, 215, "05", "Amasya"),
	(4050, 215, "06", "Ankara"),
	(4051, 215, "07", "Antalya"),
	(4052, 215, "08", "Artvin"),
	(4053, 215, "09", "Aydin"),
	(4054, 215, "10", "Balikesir"),
	(4055, 215, "11", "Bilecik"),
	(4056, 215, "12", "Bingöl"),
	(4057, 215, "13", "Bitlis"),
	(4058, 215, "14", "Bolu"),
	(4059, 215, "15", "Burdur"),
	(4060, 215, "16", "Bursa"),
	(4061, 215, "17", "Çanakkale"),
	(4062, 215, "18", "Çankiri"),
	(4063, 215, "19", "Çorum"),
	(4064, 215, "20", "Denizli"),
	(4065, 215, "21", "Diyarbakir"),
	(4066, 215, "22", "Edirne"),
	(4067, 215, "23", "Elazig"),
	(4068, 215, "24", "Erzincan"),
	(4069, 215, "25", "Erzurum"),
	(4070, 215, "26", "Eskisehir"),
	(4071, 215, "27", "Gaziantep"),
	(4072, 215, "28", "Giresun"),
	(4073, 215, "29", "Gümüshane"),
	(4074, 215, "30", "Hakkâri"),
	(4075, 215, "31", "Hatay"),
	(4076, 215, "32", "Isparta"),
	(4077, 215, "33", "Mersin"),
	(4078, 215, "34", "Istanbul"),
	(4079, 215, "35", "Izmir"),
	(4080, 215, "36", "Kars"),
	(4081, 215, "37", "Kastamonu"),
	(4082, 215, "38", "Kayseri"),
	(4083, 215, "39", "Kirklareli"),
	(4084, 215, "40", "Kirsehir"),
	(4085, 215, "41", "Kocaeli"),
	(4086, 215, "42", "Konya"),
	(4087, 215, "43", "Kütahya"),
	(4088, 215, "44", "Malatya"),
	(4089, 215, "45", "Manisa"),
	(4090, 215, "46", "Kahramanmaras"),
	(4091, 215, "47", "Mardin"),
	(4092, 215, "48", "Mugla"),
	(4093, 215, "49", "Mus"),
	(4094, 215, "50", "Nevsehir"),
	(4095, 215, "51", "Nigde"),
	(4096, 215, "52", "Ordu"),
	(4097, 215, "53", "Rize"),
	(4098, 215, "54", "Sakarya"),
	(4099, 215, "55", "Samsun"),
	(4100, 215, "56", "Siirt"),
	(4101, 215, "57", "Sinop"),
	(4102, 215, "58", "Sivas"),
	(4103, 215, "59", "Tekirdag"),
	(4104, 215, "60", "Tokat"),
	(4105, 215, "61", "Trabzon"),
	(4106, 215, "62", "Tunceli"),
	(4107, 215, "63", "Sanliurfa"),
	(4108, 215, "64", "Usak"),
	(4109, 215, "65", "Van"),
	(4110, 215, "66", "Yozgat"),
	(4111, 215, "67", "Zonguldak"),
	(4112, 215, "68", "Aksaray"),
	(4113, 215, "69", "Bayburt"),
	(4114, 215, "70", "Karaman"),
	(4115, 215, "71", "Kirikkale"),
	(4116, 215, "72", "Batman"),
	(4117, 215, "73", "Sirnak"),
	(4118, 215, "74", "Bartin"),
	(4119, 215, "75", "Ardahan"),
	(4120, 215, "76", "Igdir"),
	(4121, 215, "77", "Yalova"),
	(4122, 215, "78", "Karabük"),
	(4123, 215, "79", "Kilis"),
	(4124, 215, "80", "Osmaniye"),
	(4125, 215, "81", "Düzce"),
	(4128, 216, "A", "Ahal"),
	(4129, 216, "B", "Balkan"),
	(4130, 216, "D", "Dasoguz"),
	(4131, 216, "L", "Lebap"),
	(4132, 216, "M", "Mary"),
	(4133, 216, "S", "Aşgabat"),
	(4134, 218, "FUN", "Funafuti"),
	(4135, 218, "NIT", "Niutao"),
	(4136, 218, "NIU", "Nui"),
	(4137, 218, "NKF", "Nukufetau"),
	(4138, 218, "NKL", "Nukulaelae"),
	(4139, 218, "NMA", "Nanumea"),
	(4140, 218, "NMG", "Nanumanga"),
	(4141, 218, "VAI", "Vaitupu"),
	(4142, 219, "101", "Kalangala"),
	(4143, 219, "102", "Kampala"),
	(4144, 219, "103", "Kiboga"),
	(4145, 219, "104", "Luwero"),
	(4146, 219, "105", "Masaka"),
	(4147, 219, "106", "Mpigi"),
	(4148, 219, "107", "Mubende"),
	(4149, 219, "108", "Mukono"),
	(4150, 219, "109", "Nakasongola"),
	(4151, 219, "110", "Rakai"),
	(4152, 219, "111", "Sembabule"),
	(4153, 219, "112", "Kayunga"),
	(4154, 219, "113", "Wakiso"),
	(4155, 219, "114", "Mityana"),
	(4156, 219, "115", "Nakaseke"),
	(4157, 219, "116", "Lyantonde"),
	(4158, 219, "201", "Bugiri"),
	(4159, 219, "202", "Busia"),
	(4160, 219, "203", "Iganga"),
	(4161, 219, "204", "Jinja"),
	(4162, 219, "205", "Kamuli"),
	(4163, 219, "206", "Kapchorwa"),
	(4164, 219, "207", "Katakwi"),
	(4165, 219, "208", "Kumi"),
	(4166, 219, "209", "Mbale"),
	(4167, 219, "210", "Pallisa"),
	(4168, 219, "211", "Soroti"),
	(4169, 219, "212", "Tororo"),
	(4170, 219, "213", "Kaberamaido"),
	(4171, 219, "214", "Mayuge"),
	(4172, 219, "215", "Sironko"),
	(4173, 219, "216", "Amuria"),
	(4174, 219, "217", "Budaka"),
	(4175, 219, "218", "Bukwa"),
	(4176, 219, "219", "Butaleja"),
	(4177, 219, "220", "Kaliro"),
	(4178, 219, "221", "Manafwa"),
	(4179, 219, "222", "Namutumba"),
	(4180, 219, "223", "Bududa"),
	(4181, 219, "224", "Bukedea"),
	(4182, 219, "301", "Adjumani"),
	(4183, 219, "302", "Apac"),
	(4184, 219, "303", "Arua"),
	(4185, 219, "304", "Gulu"),
	(4186, 219, "305", "Kitgum"),
	(4187, 219, "306", "Kotido"),
	(4188, 219, "307", "Lira"),
	(4189, 219, "308", "Moroto"),
	(4190, 219, "309", "Moyo"),
	(4191, 219, "310", "Nebbi"),
	(4192, 219, "311", "Nakapiripirit"),
	(4193, 219, "312", "Pader"),
	(4194, 219, "313", "Yumbe"),
	(4195, 219, "314", "Amolatar"),
	(4196, 219, "315", "Kaabong"),
	(4197, 219, "316", "Koboko"),
	(4198, 219, "317", "Abim"),
	(4199, 219, "318", "Dokolo"),
	(4200, 219, "319", "Amuru"),
	(4201, 219, "320", "Maracha"),
	(4202, 219, "321", "Oyam"),
	(4203, 219, "401", "Bundibugyo"),
	(4204, 219, "402", "Bushenyi"),
	(4205, 219, "403", "Hoima"),
	(4206, 219, "404", "Kabale"),
	(4207, 219, "405", "Kabarole"),
	(4208, 219, "406", "Kasese"),
	(4209, 219, "407", "Kibaale"),
	(4210, 219, "408", "Kisoro"),
	(4211, 219, "409", "Masindi"),
	(4212, 219, "410", "Mbarara"),
	(4213, 219, "411", "Ntungamo"),
	(4214, 219, "412", "Rukungiri"),
	(4215, 219, "413", "Kamwenge"),
	(4216, 219, "414", "Kanungu"),
	(4217, 219, "415", "Kyenjojo"),
	(4218, 219, "416", "Ibanda"),
	(4219, 219, "417", "Isingiro"),
	(4220, 219, "418", "Kiruhura"),
	(4221, 219, "419", "Buliisa"),
	(4222, 219, "C", "Central"),
	(4223, 219, "E", "Eastern"),
	(4224, 219, "N", "Northern"),
	(4225, 219, "W", "Western"),
	(4226, 220, "05", "Vinnyts'ka Oblast'"),
	(4227, 220, "07", "Volyns'ka Oblast'"),
	(4228, 220, "09", "Luhans'ka Oblast'"),
	(4229, 220, "12", "Dnipropetrovs'ka Oblast'"),
	(4230, 220, "14", "Donets'ka Oblast'"),
	(4231, 220, "18", "Zhytomyrs'ka Oblast'"),
	(4232, 220, "21", "Zakarpats'ka Oblast'"),
	(4233, 220, "23", "Zaporiz'ka Oblast'"),
	(4234, 220, "26", "Ivano-Frankivs'ka Oblast'"),
	(4235, 220, "30", "Kyïv"),
	(4236, 220, "32", "Kyïvs'ka Oblast'"),
	(4237, 220, "35", "Kirovohrads'ka Oblast'"),
	(4238, 220, "40", "Sevastopol'"),
	(4239, 220, "43", "Respublika Krym"),
	(4240, 220, "46", "L'vivs'ka Oblast'"),
	(4241, 220, "48", "Mykolaïvs'ka Oblast'"),
	(4242, 220, "51", "Odes'ka Oblast'"),
	(4243, 220, "53", "Poltavs'ka Oblast'"),
	(4244, 220, "56", "Rivnens'ka Oblast'"),
	(4245, 220, "59", "Sums'ka Oblastß'"),
	(4246, 220, "61", "Ternopil's'ka Oblastß'"),
	(4247, 220, "63", "Kharkivs'ka Oblast'"),
	(4248, 220, "65", "Khersons'ka Oblast'"),
	(4249, 220, "68", "Khmel'nyts'ka Oblast'"),
	(4250, 220, "71", "Cherkas'ka Oblast'"),
	(4251, 220, "74", "Chernihivs'ka Oblast'"),
	(4252, 220, "77", "Chernivets'ka Oblast'"),
	(4253, 221, "AJ", "Ajman"),
	(4254, 221, "AZ", "Abu Z¸aby [Abu Dhabi]"),
	(4255, 221, "DU", "Dubayy [Dubai]"),
	(4256, 221, "FU", "Al Fujayrah"),
	(4257, 221, "RK", "Ra’s al Khaymah"),
	(4258, 221, "SH", "Ash Shariqah [Sharjah]"),
	(4259, 221, "UQ", "Umm al Qaywayn"),
	(4260, 222, "AVON", "Avon"),
	(4261, 222, "BEDS", "Bedfordshire"),
	(4262, 222, "BERK", "Berkshire"),
	(4263, 222, "BIRM", "Birmingham"),
	(4264, 222, "BORD", "Borders"),
	(4265, 222, "BUCK", "Buckinghamshire"),
	(4266, 222, "CAMB", "Cambridgeshire"),
	(4267, 222, "CENT", "Central"),
	(4268, 222, "CHES", "Cheshire"),
	(4269, 222, "CLEV", "Cleveland"),
	(4270, 222, "CLWY", "Clwyd"),
	(4271, 222, "CORN", "Cornwall"),
	(4272, 222, "CUMB", "Cumbria"),
	(4273, 222, "DERB", "Derbyshire"),
	(4274, 222, "DEVO", "Devon"),
	(4275, 222, "DORS", "Dorset"),
	(4276, 222, "DUMF", "Dumfries & Galloway"),
	(4277, 222, "DURH", "Durham"),
	(4278, 222, "DYFE", "Dyfed"),
	(4279, 222, "ESSE", "Essex"),
	(4280, 222, "ESUS", "East Sussex"),
	(4281, 222, "FIFE", "Fife"),
	(4282, 222, "GLAM", "Glamorgan"),
	(4283, 222, "GLOU", "Gloucestershire"),
	(4284, 222, "GRAM", "Grampian"),
	(4285, 222, "GWEN", "Gwent"),
	(4286, 222, "GWYN", "Gwynedd"),
	(4287, 222, "HAMP", "Hampshire"),
	(4288, 222, "HERE", "Hereford & Worcester"),
	(4289, 222, "HERT", "Hertfordshire"),
	(4290, 222, "HUMB", "Humberside"),
	(4291, 222, "KENT", "Kent"),
	(4292, 222, "LANC", "Lancashire"),
	(4293, 222, "LEIC", "Leicestershire"),
	(4294, 222, "LINC", "Lincolnshire"),
	(4295, 222, "LOND", "London"),
	(4296, 222, "LOTH", "Lothian"),
	(4297, 222, "MANC", "Manchester"),
	(4298, 222, "MERS", "Merseyside"),
	(4299, 222, "NHAM", "Northamptonshire"),
	(4300, 222, "NORF", "Norfolk"),
	(4301, 222, "NOTT", "Nottinghamshire"),
	(4302, 222, "NUMB", "Northumberland"),
	(4303, 222, "NWHI", "North west Highlands"),
	(4304, 222, "NYOR", "North Yorkshire"),
	(4305, 222, "OXFO", "Oxfordshire"),
	(4306, 222, "POWY", "Powys"),
	(4307, 222, "SHRO", "Shropshire"),
	(4308, 222, "SOME", "Somerset"),
	(4309, 222, "STAF", "Staffordshire"),
	(4310, 222, "STRA", "Strathclyde"),
	(4311, 222, "SUFF", "Suffolk"),
	(4312, 222, "SURR", "Surrey"),
	(4313, 222, "SYOR", "South Yorkshire"),
	(4314, 222, "TAYS", "Tayside"),
	(4315, 222, "TYWE", "Tyne & Wear"),
	(4316, 222, "WARW", "Warwickshire"),
	(4317, 222, "WILT", "Wiltshire"),
	(4318, 222, "WISL", "West Isles"),
	(4319, 222, "WSUS", "West Sussex"),
	(4320, 222, "WYOR", "West Yorkshire"),
	(4321, 223, "AA", "Armed Forces Americas"),
	(4322, 223, "AC", "Armed Forces Canada"),
	(4323, 223, "AE", "Armed Forces Europe"),
	(4324, 223, "AF", "Armed Forces Africa"),
	(4325, 223, "AK", "Alaska"),
	(4326, 223, "AL", "Alabama"),
	(4327, 223, "AM", "Armed Forces Middle East"),
	(4328, 223, "AP", "Armed Forces Pacific"),
	(4329, 223, "AR", "Arkansas"),
	(4330, 223, "AS", "American Samoa"),
	(4331, 223, "AZ", "Arizona"),
	(4332, 223, "CA", "California"),
	(4333, 223, "CO", "Colorado"),
	(4334, 223, "CT", "Connecticut"),
	(4335, 223, "DC", "District of Columbia"),
	(4336, 223, "DE", "Delaware"),
	(4337, 223, "FL", "Florida"),
	(4338, 223, "FM", "Federated States Of Micronesia"),
	(4339, 223, "GA", "Georgia"),
	(4340, 223, "GU", "Guam"),
	(4341, 223, "HI", "Hawaii"),
	(4342, 223, "IA", "Iowa"),
	(4343, 223, "ID", "Idaho"),
	(4344, 223, "IL", "Illinois"),
	(4345, 223, "IN", "Indiana"),
	(4346, 223, "KS", "Kansas"),
	(4347, 223, "KY", "Kentucky"),
	(4348, 223, "LA", "Louisiana"),
	(4349, 223, "MA", "Massachusetts"),
	(4350, 223, "MD", "Maryland"),
	(4351, 223, "ME", "Maine"),
	(4352, 223, "MH", "Marshall Islands"),
	(4353, 223, "MI", "Michigan"),
	(4354, 223, "MN", "Minnesota"),
	(4355, 223, "MO", "Missouri"),
	(4356, 223, "MP", "Northern Mariana Islands"),
	(4357, 223, "MS", "Mississippi"),
	(4358, 223, "MT", "Montana"),
	(4359, 223, "NC", "North Carolina"),
	(4360, 223, "ND", "North Dakota"),
	(4361, 223, "NE", "Nebraska"),
	(4362, 223, "NH", "New Hampshire"),
	(4363, 223, "NJ", "New Jersey"),
	(4364, 223, "NM", "New Mexico"),
	(4365, 223, "NV", "Nevada"),
	(4366, 223, "NY", "New York"),
	(4367, 223, "OH", "Ohio"),
	(4368, 223, "OK", "Oklahoma"),
	(4369, 223, "OR", "Oregon"),
	(4370, 223, "PA", "Pennsylvania"),
	(4371, 223, "PR", "Puerto Rico"),
	(4372, 223, "PW", "Palau"),
	(4373, 223, "RI", "Rhode Island"),
	(4374, 223, "SC", "South Carolina"),
	(4375, 223, "SD", "South Dakota"),
	(4376, 223, "TN", "Tennessee"),
	(4377, 223, "TX", "Texas"),
	(4378, 223, "UM", "United States Minor Outlying Islands"),
	(4379, 223, "UT", "Utah"),
	(4380, 223, "VA", "Virginia"),
	(4381, 223, "VI", "Virgin Islands"),
	(4382, 223, "VT", "Vermont"),
	(4383, 223, "WA", "Washington"),
	(4384, 223, "WI", "Wisconsin"),
	(4385, 223, "WV", "West Virginia"),
	(4386, 223, "WY", "Wyoming"),
	(4387, 224, "67", "Johnston Atoll"),
	(4388, 224, "71", "Midway Islands"),
	(4389, 224, "76", "Navassa Island"),
	(4390, 224, "79", "Wake Island"),
	(4391, 224, "81", "Baker Island"),
	(4392, 224, "84", "Howland Island"),
	(4393, 224, "86", "Jarvis Island"),
	(4394, 224, "89", "Kingman Reef"),
	(4395, 224, "95", "Palmyra Atoll"),
	(4396, 225, "AR", "Artigas"),
	(4397, 225, "DU", "Durazno"),
	(4398, 225, "FD", "Florida"),
	(4399, 225, "FS", "Flores"),
	(4400, 225, "LA", "Lavalleja"),
	(4401, 225, "MA", "Maldonado"),
	(4402, 225, "MO", "Montevideo"),
	(4403, 225, "PA", "Paysandú"),
	(4404, 225, "RN", "Río Negro"),
	(4405, 225, "RO", "Rocha"),
	(4406, 225, "RV", "Rivera"),
	(4407, 225, "SA", "Salto"),
	(4408, 225, "SJ", "San José"),
	(4409, 225, "SO", "Soriano"),
	(4410, 225, "TA", "Tacuarembó"),
	(4411, 225, "TT", "Treinta y Tres"),
	(4412, 226, "AN", "Andijon"),
	(4413, 226, "BU", "Buxoro"),
	(4414, 226, "FA", "Farg‘ona"),
	(4415, 226, "JI", "Jizzax"),
	(4416, 226, "NG", "Namangan"),
	(4417, 226, "NW", "Navoiy"),
	(4418, 226, "QA", "Qashqadaryo"),
	(4419, 226, "QR", "Qoraqalpog‘iston Respublikasi"),
	(4420, 226, "SA", "Samarqand"),
	(4421, 226, "SI", "Sirdaryo"),
	(4422, 226, "SU", "Surxondaryo"),
	(4423, 226, "TK", "Toshkent City"),
	(4424, 226, "TO", "Toshkent"),
	(4425, 226, "XO", "Xorazm"),
	(4426, 227, "MAP", "Malampa"),
	(4427, 227, "PAM", "Pénama"),
	(4428, 227, "SAM", "Sanma"),
	(4429, 227, "SEE", "Shéfa"),
	(4430, 227, "TAE", "Taféa"),
	(4431, 227, "TOB", "Torba"),
	(4432, 229, "AM", "Amazonas"),
	(4433, 229, "AN", "Anzoátegui"),
	(4434, 229, "AP", "Apure"),
	(4435, 229, "AR", "Aragua"),
	(4436, 229, "BA", "Barinas"),
	(4437, 229, "BO", "Bolívar"),
	(4438, 229, "CA", "Carabobo"),
	(4439, 229, "CO", "Cojedes"),
	(4440, 229, "DA", "Delta Amacuro"),
	(4441, 229, "DC", "Distrito Capital"),
	(4442, 229, "FA", "Falcón"),
	(4443, 229, "GA", "Guárico"),
	(4444, 229, "GU", "Guayana"),
	(4445, 229, "LA", "Lara"),
	(4446, 229, "ME", "Mérida"),
	(4447, 229, "MI", "Miranda"),
	(4448, 229, "MO", "Monagas"),
	(4449, 229, "NE", "Nueva Esparta"),
	(4450, 229, "PO", "Portuguesa"),
	(4451, 229, "SU", "Sucre"),
	(4452, 229, "TA", "Táchira"),
	(4453, 229, "TU", "Trujillo"),
	(4454, 229, "VA", "Vargas"),
	(4455, 229, "YA", "Yaracuy"),
	(4456, 229, "ZU", "Zulia"),
	(4457, 230, "01", "Lai Chau"),
	(4458, 230, "02", "Lao Cai"),
	(4459, 230, "03", "Ha Giang"),
	(4460, 230, "04", "Cao Bang"),
	(4461, 230, "05", "Son La"),
	(4462, 230, "06", "Yen Bai"),
	(4463, 230, "07", "Tuyen Quang"),
	(4464, 230, "09", "Lang Son"),
	(4465, 230, "13", "Quang Ninh"),
	(4466, 230, "14", "Hoa Binh"),
	(4467, 230, "15", "Ha Tay"),
	(4468, 230, "18", "Ninh Binh"),
	(4469, 230, "20", "Thai Binh"),
	(4470, 230, "21", "Thanh Hoa"),
	(4471, 230, "22", "Nghe An"),
	(4472, 230, "23", "Ha Tinh"),
	(4473, 230, "24", "Quang Binh"),
	(4474, 230, "25", "Quang Tri"),
	(4475, 230, "26", "Thua Thien-Hue"),
	(4476, 230, "27", "Quang Nam"),
	(4477, 230, "28", "Kon Tum"),
	(4478, 230, "29", "Quang Ngai"),
	(4479, 230, "30", "Gia Lai"),
	(4480, 230, "31", "Binh Dinh"),
	(4481, 230, "32", "Phu Yen"),
	(4482, 230, "33", "Dac Lac"),
	(4483, 230, "34", "Khanh Hoa"),
	(4484, 230, "35", "Lam Dong"),
	(4485, 230, "36", "Ninh Thuan"),
	(4486, 230, "37", "Tay Ninh"),
	(4487, 230, "39", "Dong Nai"),
	(4488, 230, "40", "Binh Thuan"),
	(4489, 230, "41", "Long An"),
	(4490, 230, "43", "Ba Ria-Vung Tau"),
	(4491, 230, "44", "An Giang"),
	(4492, 230, "45", "Dong Thap"),
	(4493, 230, "46", "Tien Giang"),
	(4494, 230, "47", "Kien Giang"),
	(4495, 230, "49", "Vinh Long"),
	(4496, 230, "50", "Ben Tre"),
	(4497, 230, "51", "Tra Vinh"),
	(4498, 230, "52", "Soc Trang"),
	(4499, 230, "53", "Bac Can"),
	(4500, 230, "54", "Bac Giang"),
	(4501, 230, "55", "Bac Lieu"),
	(4502, 230, "56", "Bac Ninh"),
	(4503, 230, "57", "Binh Duong"),
	(4504, 230, "58", "Binh Phuoc"),
	(4505, 230, "59", "Ca Mau"),
	(4506, 230, "61", "Hai Duong"),
	(4507, 230, "63", "Ha Nam"),
	(4508, 230, "66", "Hung Yen"),
	(4509, 230, "67", "Nam Dinh"),
	(4510, 230, "68", "Phu Tho"),
	(4511, 230, "69", "Thai Nguyen"),
	(4512, 230, "70", "Vinh Phuc"),
	(4513, 230, "71", "Dien Bien"),
	(4514, 230, "72", "Dak Nong"),
	(4515, 230, "73", "Hau Giang"),
	(4516, 230, "CT", "Can Tho"),
	(4517, 230, "DN", "Da Nang"),
	(4518, 230, "HN", "Ha Noi"),
	(4519, 230, "HP", "Hai Phong"),
	(4520, 230, "SG", "Ho Chi Minh [Sai Gon]"),
	(4521, 234, "BOD", "Boujdour"),
	(4522, 234, "ESM", "Es Semara"),
	(4523, 234, "LAA", "Laayoune"),
	(4524, 234, "OUD", "Oued el Dahab"),
	(4525, 235, "AB", "Abyan"),
	(4526, 235, "AD", "ʿAdan"),
	(4527, 235, "AM", "'Amran"),
	(4528, 235, "BA", "al-Baiḍā"),
	(4529, 235, "DA", "Ad Dāli‘"),
	(4530, 235, "DH", "Dhamar"),
	(4531, 235, "HD", "Hadramawt"),
	(4532, 235, "HJ", "Hajjah"),
	(4533, 235, "HU", "Al Hudaydah"),
	(4534, 235, "IB", "Ibb"),
	(4535, 235, "JA", "Al Jawf"),
	(4536, 235, "LA", "Laḩij"),
	(4537, 235, "MA", "Ma'rib"),
	(4538, 235, "MR", "Al Mahrah"),
	(4539, 235, "MW", "Al Mahwit"),
	(4540, 235, "RA", "Raymah"),
	(4541, 235, "SA", "Şan‘ā"),
	(4542, 235, "SD", "Sa`dah"),
	(4543, 235, "SH", "Shabwah"),
	(4544, 235, "SN", "Sanʿā"),
	(4545, 235, "TA", "Taʿizz"),
	(4546, 238, "01", "Western"),
	(4547, 238, "02", "Central"),
	(4548, 238, "03", "Eastern"),
	(4549, 238, "04", "Luapula"),
	(4550, 238, "05", "Northern"),
	(4551, 238, "06", "North-Western"),
	(4552, 238, "07", "Southern"),
	(4553, 238, "08", "Copperbelt"),
	(4554, 238, "09", "Lusaka"),
	(4555, 239, "BU", "Bulawayo"),
	(4556, 239, "HA", "Harare"),
	(4557, 239, "MA", "Manicaland"),
	(4558, 239, "MC", "Mashonaland Central"),
	(4559, 239, "ME", "Mashonaland East"),
	(4560, 239, "MI", "Midlands"),
	(4561, 239, "MN", "Matabeleland North"),
	(4562, 239, "MS", "Matabeleland South"),
	(4563, 239, "MV", "Masvingo"),
	(4564, 239, "MW", "Mashonaland West"),
	(4565, 240, "00", "Belgrade"),
	(4566, 240, "01", "Severnobački okrug"),
	(4567, 240, "02", "Srednjebanatski okrug"),
	(4568, 240, "03", "Severnobanatski okrug"),
	(4569, 240, "04", "Južnobanatski okrug"),
	(4570, 240, "05", "Zapadnobaèki okrug"),
	(4571, 240, "06", "Južnobanatski okrug"),
	(4572, 240, "07", "Sremski okrug"),
	(4573, 240, "08", "Mačvanski okrug"),
	(4574, 240, "09", "Kolubarski okrug"),
	(4575, 240, "10", "Podunavski okrug"),
	(4576, 240, "11", "Braničevski okrug"),
	(4577, 240, "12", "Šumadijski okrug"),
	(4578, 240, "13", "Pomoravski okrug"),
	(4579, 240, "14", "Borski okrug"),
	(4580, 240, "15", "Zajeèarski okrug"),
	(4581, 240, "16", "Zlatiborski okrug"),
	(4582, 240, "17", "Moravički okrug"),
	(4583, 240, "18", "Raška okrug"),
	(4584, 240, "19", "Rasinski okrug"),
	(4585, 240, "20", "Nišavski okrug"),
	(4586, 240, "21", "Toplièki okrug"),
	(4587, 240, "22", "Pirotski okrug"),
	(4588, 240, "23", "Jablanički okrug"),
	(4589, 240, "24", "Pčinjski okrug"),
	(4590, 240, "25", "Kosovski okrug"),
	(4591, 240, "26", "Pećki okrug"),
	(4592, 240, "27", "Prizrenski okrug"),
	(4593, 240, "28", "Kosovsko-Mitrovački okrug"),
	(4594, 240, "29", "Kosovsko-Pomoravski okrug"),
	(4595, 241, "01", "Andrijevica"),
	(4596, 241, "02", "Bar"),
	(4597, 241, "03", "Berane"),
	(4598, 241, "04", "Bijelo Polje"),
	(4599, 241, "05", "Budva"),
	(4600, 241, "06", "Cetinje"),
	(4601, 241, "07", "Danilovgrad"),
	(4602, 241, "08", "Herceg-Novi"),
	(4603, 241, "09", "Kolašin"),
	(4604, 241, "10", "Kotor"),
	(4605, 241, "11", "Mojkovac"),
	(4606, 241, "12", "Nikšic´"),
	(4607, 241, "13", "Plav"),
	(4608, 241, "14", "Pljevlja"),
	(4609, 241, "15", "Plužine"),
	(4610, 241, "16", "Podgorica"),
	(4611, 241, "17", "Rožaje"),
	(4612, 241, "18", "Šavnik"),
	(4613, 241, "19", "Tivat"),
	(4614, 241, "20", "Ulcinj"),
	(4615, 241, "21", "Žabljak"),
	(4616, 244, "BO", "Bonaire"),
	(4617, 244, "SA", "Saba"),
	(4618, 244, "SE", "Sint Eustatius"),
	(4619, 245, "BC", "Bas-Congo"),
	(4620, 245, "BN", "Bandundu"),
	(4621, 245, "EQ", "Équateur"),
	(4622, 245, "KA", "Katanga"),
	(4623, 245, "KE", "Kasai-Oriental"),
	(4624, 245, "KN", "Kinshasa"),
	(4625, 245, "KW", "Kasai-Occidental"),
	(4626, 245, "MA", "Maniema"),
	(4627, 245, "NK", "Nord-Kivu"),
	(4628, 245, "OR", "Orientale"),
	(4629, 245, "SK", "Sud-Kivu"),
	(4630, 252, "BTH", "Bethlehem Bayt Laḩm"),
	(4631, 252, "DEB", "Deir El Balah Dayr al Balaḩ"),
	(4632, 252, "GZA", "Gaza Ghazzah"),
	(4633, 252, "HBN", "Hebron Al Khalīl"),
	(4634, 252, "JEM", "Jerusalem Al Quds"),
	(4635, 252, "JEN", "Jenin Janīn"),
	(4636, 252, "JRH", "Jericho – Al Aghwar Arīḩā wa al Aghwār"),
	(4637, 252, "KYS", "Khan Yunis Khān Yūnis"),
	(4638, 252, "NBS", "Nablus Nāblus"),
	(4639, 252, "NGZ", "North Gaza Shamāl Ghazzah"),
	(4640, 252, "QQA", "Qalqilya Qalqīlyah"),
	(4641, 252, "RBH", "Ramallah Rām Allāh wa al Bīrah"),
	(4642, 252, "RFH", "Rafah Rafaḩ"),
	(4643, 252, "SLT", "Salfit Salfīt"),
	(4644, 252, "TBS", "Tubas Ţūbās"),
	(4645, 252, "TKM", "Tulkarm Ţūlkarm"),
	(4646, 253, "BN", "Northern Bahr el-Ghazal"),
	(4647, 253, "BW", "Western Bahr el-Ghazal"),
	(4648, 253, "EC", "Central Equatoria"),
	(4649, 253, "EE", "Eastern Equatoria"),
	(4650, 253, "EW", "Western Equatoria"),
	(4651, 253, "JG", "Jonglei"),
	(4652, 253, "LK", "Lakes"),
	(4653, 253, "NU", "Upper Nile"),
	(4654, 253, "UY", "Unity"),
	(4655, 253, "WR", "Warrap"),
	(4656, 255, "AL", "Aileu"),
	(4657, 255, "AN", "Ainaro"),
	(4658, 255, "BA", "Baucau"),
	(4659, 255, "BO", "Bobonaro"),
	(4660, 255, "CO", "Cova Lima"),
	(4661, 255, "DI", "Díli"),
	(4662, 255, "ER", "Ermera"),
	(4663, 255, "LA", "Lautem"),
	(4664, 255, "LI", "Liquiça"),
	(4665, 255, "MF", "Manufahi"),
	(4666, 255, "MT", "Manatuto"),
	(4667, 255, "OE", "Oecussi"),
	(4668, 255, "VI", "Viqueque"),
	(4669, 124, "CA", "Capellen"),
	(4670, 124, "CL", "Clerf"),
	(4671, 124, "EC", "Echternach"),
	(4672, 124, "ES", "Esch an der Alzette"),
	(4673, 124, "ME", "Mersch"),
	(4674, 124, "RD", "Redingen"),
	(4675, 124, "RM", "Remich"),
	(4676, 124, "VD", "Vianden"),
	(4677, 124, "WI", "Wiltz"),
	(4678, 240, "30", "Kosovsko-Pristina okrug"),
	(4679, 240, "31", "Kosovsko-Peja okrug"),
	(4680, 240, "32", "Kosovsko-Prizren okrug"),
	(4681, 240, "33", "Kosovsko-Ferizaj okrug"),
	(4682, 240, "34", "Kosovsko-Gjilan okrug"),
	(4683, 240, "35", "Kosovsko-Gjakova okrug");